/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.rel.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.HashMultimap;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptPredicateList;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptUtil;
import org.apache.hive.druid.org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.hive.druid.org.apache.calcite.plan.volcano.RelSubset;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.core.Aggregate;
import org.apache.hive.druid.org.apache.calcite.rel.core.Exchange;
import org.apache.hive.druid.org.apache.calcite.rel.core.Filter;
import org.apache.hive.druid.org.apache.calcite.rel.core.Join;
import org.apache.hive.druid.org.apache.calcite.rel.core.JoinRelType;
import org.apache.hive.druid.org.apache.calcite.rel.core.Project;
import org.apache.hive.druid.org.apache.calcite.rel.core.Sort;
import org.apache.hive.druid.org.apache.calcite.rel.core.TableScan;
import org.apache.hive.druid.org.apache.calcite.rel.core.Union;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.BuiltInMetadata;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.RelMdExpressionLineage;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.hive.druid.org.apache.calcite.rex.RexBuilder;
import org.apache.hive.druid.org.apache.calcite.rex.RexInputRef;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.rex.RexTableInputRef;
import org.apache.hive.druid.org.apache.calcite.rex.RexUtil;
import org.apache.hive.druid.org.apache.calcite.util.BuiltInMethod;
import org.apache.hive.druid.org.apache.calcite.util.ImmutableBitSet;
import org.apache.hive.druid.org.apache.calcite.util.Util;

public class RelMdAllPredicates
implements MetadataHandler<BuiltInMetadata.AllPredicates> {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(BuiltInMethod.ALL_PREDICATES.method, new RelMdAllPredicates());

    @Override
    public MetadataDef<BuiltInMetadata.AllPredicates> getDef() {
        return BuiltInMetadata.AllPredicates.DEF;
    }

    public RelOptPredicateList getAllPredicates(RelNode rel, RelMetadataQuery mq) {
        return null;
    }

    public RelOptPredicateList getAllPredicates(HepRelVertex rel, RelMetadataQuery mq) {
        return mq.getAllPredicates(rel.getCurrentRel());
    }

    public RelOptPredicateList getAllPredicates(RelSubset rel, RelMetadataQuery mq) {
        return mq.getAllPredicates(Util.first(rel.getBest(), rel.getOriginal()));
    }

    public RelOptPredicateList getAllPredicates(TableScan table, RelMetadataQuery mq) {
        return RelOptPredicateList.EMPTY;
    }

    public RelOptPredicateList getAllPredicates(Project project, RelMetadataQuery mq) {
        return mq.getAllPredicates(project.getInput());
    }

    public RelOptPredicateList getAllPredicates(Filter filter, RelMetadataQuery mq) {
        RelNode input = filter.getInput();
        RexBuilder rexBuilder = filter.getCluster().getRexBuilder();
        RexNode pred = filter.getCondition();
        RelOptPredicateList predsBelow = mq.getAllPredicates(input);
        if (predsBelow == null) {
            return null;
        }
        LinkedHashSet<RelDataTypeField> inputExtraFields = new LinkedHashSet<RelDataTypeField>();
        RelOptUtil.InputFinder inputFinder = new RelOptUtil.InputFinder(inputExtraFields);
        pred.accept(inputFinder);
        ImmutableBitSet inputFieldsUsed = inputFinder.inputBitSet.build();
        LinkedHashMap<RexInputRef, Set<RexNode>> mapping = new LinkedHashMap<RexInputRef, Set<RexNode>>();
        for (int idx : inputFieldsUsed) {
            RexInputRef ref = RexInputRef.of(idx, filter.getRowType().getFieldList());
            Set<RexNode> originalExprs = mq.getExpressionLineage(filter, ref);
            if (originalExprs == null) {
                return null;
            }
            mapping.put(ref, originalExprs);
        }
        return predsBelow.union(rexBuilder, RelOptPredicateList.of(rexBuilder, RelMdExpressionLineage.createAllPossibleExpressions(rexBuilder, pred, mapping)));
    }

    public RelOptPredicateList getAllPredicates(Join join, RelMetadataQuery mq) {
        if (join.getJoinType() != JoinRelType.INNER) {
            return null;
        }
        final RexBuilder rexBuilder = join.getCluster().getRexBuilder();
        RexNode pred = join.getCondition();
        HashMultimap<List<String>, RexTableInputRef.RelTableRef> qualifiedNamesToRefs = HashMultimap.create();
        RelOptPredicateList newPreds = RelOptPredicateList.EMPTY;
        for (RelNode input : join.getInputs()) {
            RelOptPredicateList inputPreds = mq.getAllPredicates(input);
            if (inputPreds == null) {
                return null;
            }
            Set<RexTableInputRef.RelTableRef> tableRefs = mq.getTableReferences(input);
            if (input == join.getLeft()) {
                for (RexTableInputRef.RelTableRef relTableRef : tableRefs) {
                    qualifiedNamesToRefs.put(relTableRef.getQualifiedName(), relTableRef);
                }
                newPreds = newPreds.union(rexBuilder, inputPreds);
                continue;
            }
            final HashMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> currentTablesMapping = new HashMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef>();
            for (RexTableInputRef.RelTableRef rightRef : tableRefs) {
                int shift = 0;
                Collection lRefs = qualifiedNamesToRefs.get(rightRef.getQualifiedName());
                if (lRefs != null) {
                    shift = lRefs.size();
                }
                currentTablesMapping.put(rightRef, RexTableInputRef.RelTableRef.of(rightRef.getTable(), shift + rightRef.getEntityNumber()));
            }
            ArrayList<RexNode> arrayList = Lists.newArrayList(Iterables.transform(inputPreds.pulledUpPredicates, new Function<RexNode, RexNode>(){

                @Override
                public RexNode apply(RexNode e) {
                    return RexUtil.swapTableReferences(rexBuilder, e, currentTablesMapping);
                }
            }));
            newPreds = newPreds.union(rexBuilder, RelOptPredicateList.of(rexBuilder, arrayList));
        }
        LinkedHashSet<RelDataTypeField> inputExtraFields = new LinkedHashSet<RelDataTypeField>();
        RelOptUtil.InputFinder inputFinder = new RelOptUtil.InputFinder(inputExtraFields);
        pred.accept(inputFinder);
        ImmutableBitSet inputFieldsUsed = inputFinder.inputBitSet.build();
        LinkedHashMap<RexInputRef, Set<RexNode>> mapping = new LinkedHashMap<RexInputRef, Set<RexNode>>();
        Iterator<Comparable<RexTableInputRef.RelTableRef>> iterator = inputFieldsUsed.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            RexInputRef inputRef = RexInputRef.of(n, join.getRowType().getFieldList());
            Set<RexNode> originalExprs = mq.getExpressionLineage(join, inputRef);
            if (originalExprs == null) {
                return null;
            }
            RexInputRef ref = RexInputRef.of(n, join.getRowType().getFieldList());
            mapping.put(ref, originalExprs);
        }
        return newPreds.union(rexBuilder, RelOptPredicateList.of(rexBuilder, RelMdExpressionLineage.createAllPossibleExpressions(rexBuilder, pred, mapping)));
    }

    public RelOptPredicateList getAllPredicates(Aggregate agg, RelMetadataQuery mq) {
        return mq.getAllPredicates(agg.getInput());
    }

    public RelOptPredicateList getAllPredicates(Union union, RelMetadataQuery mq) {
        final RexBuilder rexBuilder = union.getCluster().getRexBuilder();
        HashMultimap<List<String>, RexTableInputRef.RelTableRef> qualifiedNamesToRefs = HashMultimap.create();
        RelOptPredicateList newPreds = RelOptPredicateList.EMPTY;
        for (int i = 0; i < union.getInputs().size(); ++i) {
            RelNode input = union.getInput(i);
            RelOptPredicateList inputPreds = mq.getAllPredicates(input);
            if (inputPreds == null) {
                return null;
            }
            Set<RexTableInputRef.RelTableRef> tableRefs = mq.getTableReferences(input);
            if (i == 0) {
                for (RexTableInputRef.RelTableRef relTableRef : tableRefs) {
                    qualifiedNamesToRefs.put(relTableRef.getQualifiedName(), relTableRef);
                }
                newPreds = newPreds.union(rexBuilder, inputPreds);
                continue;
            }
            final HashMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> currentTablesMapping = new HashMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef>();
            for (RexTableInputRef.RelTableRef rightRef : tableRefs) {
                int shift = 0;
                Collection lRefs = qualifiedNamesToRefs.get(rightRef.getQualifiedName());
                if (lRefs != null) {
                    shift = lRefs.size();
                }
                currentTablesMapping.put(rightRef, RexTableInputRef.RelTableRef.of(rightRef.getTable(), shift + rightRef.getEntityNumber()));
            }
            for (RexTableInputRef.RelTableRef newRef : currentTablesMapping.values()) {
                qualifiedNamesToRefs.put(newRef.getQualifiedName(), newRef);
            }
            ArrayList<RexNode> arrayList = Lists.newArrayList(Iterables.transform(inputPreds.pulledUpPredicates, new Function<RexNode, RexNode>(){

                @Override
                public RexNode apply(RexNode e) {
                    return RexUtil.swapTableReferences(rexBuilder, e, currentTablesMapping);
                }
            }));
            newPreds = newPreds.union(rexBuilder, RelOptPredicateList.of(rexBuilder, arrayList));
        }
        return newPreds;
    }

    public RelOptPredicateList getAllPredicates(Sort sort, RelMetadataQuery mq) {
        return mq.getAllPredicates(sort.getInput());
    }

    public RelOptPredicateList getAllPredicates(Exchange exchange, RelMetadataQuery mq) {
        return mq.getAllPredicates(exchange.getInput());
    }
}

