/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.emitter;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.name.Named;
import com.google.inject.util.Providers;
import java.security.NoSuchAlgorithmException;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.io.druid.guice.JsonConfigProvider;
import org.apache.hive.druid.io.druid.guice.LazySingleton;
import org.apache.hive.druid.io.druid.guice.ManageLifecycle;
import org.apache.hive.druid.io.druid.java.util.common.concurrent.Execs;
import org.apache.hive.druid.io.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.hive.druid.io.druid.java.util.emitter.core.Emitter;
import org.apache.hive.druid.io.druid.java.util.emitter.core.HttpEmitterConfig;
import org.apache.hive.druid.io.druid.java.util.emitter.core.HttpPostEmitter;
import org.apache.hive.druid.io.netty.handler.ssl.ClientAuth;
import org.apache.hive.druid.io.netty.handler.ssl.JdkSslContext;
import org.apache.hive.druid.io.netty.util.HashedWheelTimer;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;

public class HttpEmitterModule
implements Module {
    public void configure(Binder binder) {
        JsonConfigProvider.bind(binder, "druid.emitter.http", HttpEmitterConfig.class);
        HttpEmitterModule.configureSsl(binder);
    }

    static void configureSsl(Binder binder) {
        SSLContext context;
        try {
            context = SSLContext.getDefault();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        binder.bind(SSLContext.class).toProvider(Providers.of((Object)context)).in(LazySingleton.class);
    }

    static AsyncHttpClient createAsyncHttpClient(String nameFormat, String timerThreadNameFormat, @Nullable SSLContext sslContext) {
        DefaultAsyncHttpClientConfig.Builder builder = new DefaultAsyncHttpClientConfig.Builder().setThreadFactory(Execs.makeThreadFactory(nameFormat)).setNettyTimer(new HashedWheelTimer(Execs.makeThreadFactory(timerThreadNameFormat)));
        if (sslContext != null) {
            builder.setSslContext(new JdkSslContext(sslContext, true, ClientAuth.NONE));
        }
        return new DefaultAsyncHttpClient(builder.build());
    }

    @Provides
    @ManageLifecycle
    @Named(value="http")
    public Emitter getEmitter(Supplier<HttpEmitterConfig> config, @Nullable SSLContext sslContext, Lifecycle lifecycle, ObjectMapper jsonMapper) {
        return new HttpPostEmitter(config.get(), lifecycle.addCloseableInstance(HttpEmitterModule.createAsyncHttpClient("HttpPostEmitter-AsyncHttpClient-%d", "HttpPostEmitter-AsyncHttpClient-Timer-%d", sslContext)), jsonMapper);
    }
}

