/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordinator;

import com.google.inject.Inject;
import java.util.ArrayList;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.io.druid.client.ImmutableDruidDataSource;
import org.apache.hive.druid.io.druid.client.indexing.IndexingServiceClient;
import org.apache.hive.druid.io.druid.indexer.TaskStatusPlus;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.guava.Comparators;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.hive.druid.io.druid.server.coordinator.helper.DruidCoordinatorHelper;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;

public class DruidCoordinatorCleanupPendingSegments
implements DruidCoordinatorHelper {
    private static final Logger log = new Logger(DruidCoordinatorCleanupPendingSegments.class);
    private static final Period KEEP_PENDING_SEGMENTS_OFFSET = new Period((Object)"P1D");
    private final IndexingServiceClient indexingServiceClient;

    @Inject
    public DruidCoordinatorCleanupPendingSegments(IndexingServiceClient indexingServiceClient) {
        this.indexingServiceClient = indexingServiceClient;
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        ArrayList<Object> createdTimes = new ArrayList<Object>();
        createdTimes.add(this.indexingServiceClient.getRunningTasks().stream().map(TaskStatusPlus::getCreatedTime).min(Comparators.naturalNullsFirst()).orElse(DateTimes.nowUtc()));
        createdTimes.add(this.indexingServiceClient.getPendingTasks().stream().map(TaskStatusPlus::getCreatedTime).min(Comparators.naturalNullsFirst()).orElse(DateTimes.nowUtc()));
        createdTimes.add(this.indexingServiceClient.getWaitingTasks().stream().map(TaskStatusPlus::getCreatedTime).min(Comparators.naturalNullsFirst()).orElse(DateTimes.nowUtc()));
        TaskStatusPlus completeTaskStatus = this.indexingServiceClient.getLastCompleteTask();
        if (completeTaskStatus != null) {
            createdTimes.add(completeTaskStatus.getCreatedTime());
        }
        createdTimes.sort(Comparators.naturalNullsFirst());
        Preconditions.checkState(!createdTimes.isEmpty(), "Failed to gather createdTimes of tasks");
        DateTime pendingSegmentsCleanupEndTime = ((DateTime)createdTimes.get(0)).minus((ReadablePeriod)KEEP_PENDING_SEGMENTS_OFFSET);
        for (ImmutableDruidDataSource dataSource : params.getDataSources()) {
            if (params.getCoordinatorDynamicConfig().getKillPendingSegmentsSkipList().contains(dataSource.getName())) continue;
            log.info("Killed [%d] pendingSegments created until [%s] for dataSource[%s]", this.indexingServiceClient.killPendingSegments(dataSource.getName(), pendingSegmentsCleanupEndTime), pendingSegmentsCleanupEndTime, dataSource);
        }
        return params;
    }
}

