/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import java.util.Iterator;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.java.util.common.io.Closer;
import org.apache.hive.druid.io.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.hive.druid.io.druid.segment.data.ColumnarMultiInts;
import org.apache.hive.druid.io.druid.segment.data.CompressedColumnarIntsSupplier;
import org.apache.hive.druid.io.druid.segment.data.CompressedVSizeColumnarIntsSupplier;
import org.apache.hive.druid.io.druid.segment.data.CompressedVSizeColumnarMultiIntsSupplier;
import org.apache.hive.druid.io.druid.segment.data.CompressionStrategy;
import org.apache.hive.druid.io.druid.segment.data.IndexedInts;
import org.apache.hive.druid.io.druid.segment.data.WritableSupplier;

public class V3CompressedVSizeColumnarMultiIntsSupplier
implements WritableSupplier<ColumnarMultiInts> {
    public static final byte VERSION = 3;
    private final CompressedColumnarIntsSupplier offsetSupplier;
    private final CompressedVSizeColumnarIntsSupplier valueSupplier;

    private V3CompressedVSizeColumnarMultiIntsSupplier(CompressedColumnarIntsSupplier offsetSupplier, CompressedVSizeColumnarIntsSupplier valueSupplier) {
        this.offsetSupplier = offsetSupplier;
        this.valueSupplier = valueSupplier;
    }

    public static V3CompressedVSizeColumnarMultiIntsSupplier fromByteBuffer(ByteBuffer buffer, ByteOrder order) {
        byte versionFromBuffer = buffer.get();
        if (versionFromBuffer == 3) {
            CompressedColumnarIntsSupplier offsetSupplier = CompressedColumnarIntsSupplier.fromByteBuffer(buffer, order);
            CompressedVSizeColumnarIntsSupplier valueSupplier = CompressedVSizeColumnarIntsSupplier.fromByteBuffer(buffer, order);
            return new V3CompressedVSizeColumnarMultiIntsSupplier(offsetSupplier, valueSupplier);
        }
        throw new IAE("Unknown version[%s]", versionFromBuffer);
    }

    @VisibleForTesting
    public static V3CompressedVSizeColumnarMultiIntsSupplier fromIterable(Iterable<IndexedInts> objectsIterable, int offsetChunkFactor, int maxValue, ByteOrder byteOrder, CompressionStrategy compression, Closer closer) {
        Iterator<IndexedInts> objects = objectsIterable.iterator();
        IntArrayList offsetList = new IntArrayList();
        IntArrayList values = new IntArrayList();
        int offset = 0;
        while (objects.hasNext()) {
            IndexedInts next = objects.next();
            offsetList.add(offset);
            for (int i = 0; i < next.size(); ++i) {
                values.add(next.get(i));
            }
            offset += next.size();
        }
        offsetList.add(offset);
        CompressedColumnarIntsSupplier headerSupplier = CompressedColumnarIntsSupplier.fromList(offsetList, offsetChunkFactor, byteOrder, compression, closer);
        CompressedVSizeColumnarIntsSupplier valuesSupplier = CompressedVSizeColumnarIntsSupplier.fromList(values, maxValue, CompressedVSizeColumnarIntsSupplier.maxIntsInBufferForValue(maxValue), byteOrder, compression, closer);
        return new V3CompressedVSizeColumnarMultiIntsSupplier(headerSupplier, valuesSupplier);
    }

    @Override
    public long getSerializedSize() throws IOException {
        return 1L + this.offsetSupplier.getSerializedSize() + this.valueSupplier.getSerializedSize();
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        channel.write(ByteBuffer.wrap(new byte[]{3}));
        this.offsetSupplier.writeTo(channel, smoosher);
        this.valueSupplier.writeTo(channel, smoosher);
    }

    @Override
    public ColumnarMultiInts get() {
        return new CompressedVSizeColumnarMultiIntsSupplier.CompressedVSizeColumnarMultiInts(this.offsetSupplier.get(), this.valueSupplier.get());
    }
}

