/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.hive.druid.io.druid.collections.bitmap.BitmapFactory;
import org.apache.hive.druid.io.druid.collections.bitmap.MutableBitmap;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.io.druid.segment.ColumnValueSelector;
import org.apache.hive.druid.io.druid.segment.DimensionHandlerUtils;
import org.apache.hive.druid.io.druid.segment.DimensionIndexer;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;
import org.apache.hive.druid.io.druid.segment.DoubleColumnSelector;
import org.apache.hive.druid.io.druid.segment.DoubleWrappingDimensionSelector;
import org.apache.hive.druid.io.druid.segment.data.Indexed;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.io.druid.segment.incremental.TimeAndDimsHolder;

public class DoubleDimensionIndexer
implements DimensionIndexer<Double, Double, Double> {
    @Override
    public Double processRowValsToUnsortedEncodedKeyComponent(Object dimValues, boolean reportParseExceptions) {
        if (dimValues instanceof List) {
            throw new UnsupportedOperationException("Numeric columns do not support multivalue rows.");
        }
        Double ret = DimensionHandlerUtils.convertObjectToDouble(dimValues, reportParseExceptions);
        return ret == null ? DimensionHandlerUtils.ZERO_DOUBLE : ret;
    }

    @Override
    public Double getUnsortedEncodedValueFromSorted(Double sortedIntermediateValue) {
        return sortedIntermediateValue;
    }

    @Override
    public Indexed<Double> getSortedIndexedValues() {
        throw new UnsupportedOperationException("Numeric columns do not support value dictionaries.");
    }

    @Override
    public Double getMinValue() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public Double getMaxValue() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public int getCardinality() {
        return -1;
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec spec, TimeAndDimsHolder currEntry, IncrementalIndex.DimensionDesc desc) {
        return new DoubleWrappingDimensionSelector(this.makeColumnValueSelector(currEntry, desc), spec.getExtractionFn());
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(final TimeAndDimsHolder currEntry, IncrementalIndex.DimensionDesc desc) {
        final int dimIndex = desc.getIndex();
        class IndexerDoubleColumnSelector
        implements DoubleColumnSelector {
            IndexerDoubleColumnSelector() {
            }

            @Override
            public double getDouble() {
                Object[] dims = currEntry.get().getDims();
                if (dimIndex >= dims.length) {
                    return 0.0;
                }
                return (Double)dims[dimIndex];
            }

            @Override
            @Nullable
            public Double getObject() {
                Object[] dims = currEntry.get().getDims();
                if (dimIndex >= dims.length) {
                    return null;
                }
                return (Double)dims[dimIndex];
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            }
        }
        return new IndexerDoubleColumnSelector();
    }

    @Override
    public int compareUnsortedEncodedKeyComponents(@Nullable Double lhs, @Nullable Double rhs) {
        return Double.compare(DimensionHandlerUtils.nullToZero(lhs), DimensionHandlerUtils.nullToZero(rhs));
    }

    @Override
    public boolean checkUnsortedEncodedKeyComponentsEqual(@Nullable Double lhs, @Nullable Double rhs) {
        return DimensionHandlerUtils.nullToZero(lhs).equals(DimensionHandlerUtils.nullToZero(rhs));
    }

    @Override
    public int getUnsortedEncodedKeyComponentHashCode(@Nullable Double key) {
        return DimensionHandlerUtils.nullToZero(key).hashCode();
    }

    @Override
    public Object convertUnsortedEncodedKeyComponentToActualArrayOrList(Double key, boolean asList) {
        return key;
    }

    @Override
    public Double convertUnsortedEncodedKeyComponentToSortedEncodedKeyComponent(Double key) {
        return key;
    }

    @Override
    public void fillBitmapsFromUnsortedEncodedKeyComponent(Double key, int rowNum, MutableBitmap[] bitmapIndexes, BitmapFactory factory) {
        throw new UnsupportedOperationException("Numeric columns do not support bitmaps.");
    }
}

