/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation;

import java.nio.ByteBuffer;
import org.apache.hive.druid.io.druid.query.aggregation.SimpleDoubleBufferAggregator;
import org.apache.hive.druid.io.druid.segment.BaseDoubleColumnValueSelector;

public class DoubleMinBufferAggregator
extends SimpleDoubleBufferAggregator {
    DoubleMinBufferAggregator(BaseDoubleColumnValueSelector selector) {
        super(selector);
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        buf.putDouble(position, Double.POSITIVE_INFINITY);
    }

    @Override
    public void putFirst(ByteBuffer buf, int position, double value) {
        if (!Double.isNaN(value)) {
            buf.putDouble(position, value);
        } else {
            this.init(buf, position);
        }
    }

    @Override
    public void aggregate(ByteBuffer buf, int position, double value) {
        buf.putDouble(position, Math.min(buf.getDouble(position), value));
    }
}

