/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.metadata;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.metadata.MetadataStorageActionHandlerTypes;
import org.apache.hive.druid.io.druid.metadata.SQLMetadataConnector;
import org.apache.hive.druid.io.druid.metadata.SQLMetadataStorageActionHandler;
import org.joda.time.DateTime;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;

public class SQLServerMetadataStorageActionHandler<EntryType, StatusType, LogType, LockType>
extends SQLMetadataStorageActionHandler<EntryType, StatusType, LogType, LockType> {
    public SQLServerMetadataStorageActionHandler(SQLMetadataConnector connector, ObjectMapper jsonMapper, MetadataStorageActionHandlerTypes<EntryType, StatusType, LogType, LockType> types, String entryTypeName, String entryTable, String logTable, String lockTable) {
        super(connector, jsonMapper, types, entryTypeName, entryTable, logTable, lockTable);
    }

    @Override
    protected Query<Map<String, Object>> createInactiveStatusesSinceQuery(Handle handle, DateTime timestamp, @Nullable Integer maxNumStatuses) {
        String sql = maxNumStatuses == null ? "SELECT " : "SELECT TOP :n ";
        sql = sql + StringUtils.format("    id,   status_payload FROM   %s WHERE   active = FALSE AND created_date >= :start ORDER BY created_date DESC", this.getEntryTable());
        Query query = (Query)handle.createQuery(sql).bind("start", timestamp.toString());
        if (maxNumStatuses != null) {
            query = (Query)query.bind("n", maxNumStatuses);
        }
        return query;
    }
}

