/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.indexer;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.io.druid.indexer.TaskLocation;
import org.apache.hive.druid.io.druid.indexer.TaskState;
import org.joda.time.DateTime;

public class TaskStatusPlus {
    private final String id;
    private final DateTime createdTime;
    private final DateTime queueInsertionTime;
    private final TaskState state;
    private final Long duration;
    private final TaskLocation location;

    @JsonCreator
    public TaskStatusPlus(@JsonProperty(value="id") String id, @JsonProperty(value="createdTime") DateTime createdTime, @JsonProperty(value="queueInsertionTime") DateTime queueInsertionTime, @JsonProperty(value="statusCode") @Nullable TaskState state, @JsonProperty(value="duration") @Nullable Long duration, @JsonProperty(value="location") TaskLocation location) {
        if (state != null && state.isComplete()) {
            Preconditions.checkNotNull(duration, "duration");
        }
        this.id = Preconditions.checkNotNull(id, "id");
        this.createdTime = Preconditions.checkNotNull(createdTime, "createdTime");
        this.queueInsertionTime = Preconditions.checkNotNull(queueInsertionTime, "queueInsertionTime");
        this.state = state;
        this.duration = duration;
        this.location = Preconditions.checkNotNull(location, "location");
    }

    @JsonProperty
    public String getId() {
        return this.id;
    }

    @JsonProperty
    public DateTime getCreatedTime() {
        return this.createdTime;
    }

    @JsonProperty
    public DateTime getQueueInsertionTime() {
        return this.queueInsertionTime;
    }

    @Nullable
    @JsonProperty(value="statusCode")
    public TaskState getState() {
        return this.state;
    }

    @JsonProperty
    public Long getDuration() {
        return this.duration;
    }

    @JsonProperty
    public TaskLocation getLocation() {
        return this.location;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskStatusPlus that = (TaskStatusPlus)o;
        if (!this.id.equals(that.id)) {
            return false;
        }
        if (!this.createdTime.equals((Object)that.createdTime)) {
            return false;
        }
        if (!this.queueInsertionTime.equals((Object)that.queueInsertionTime)) {
            return false;
        }
        if (!Objects.equals((Object)this.state, (Object)that.state)) {
            return false;
        }
        if (!Objects.equals(this.duration, that.duration)) {
            return false;
        }
        return this.location.equals(that.location);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.createdTime, this.queueInsertionTime, this.state, this.duration, this.location});
    }
}

