/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.guice;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutorService;
import org.apache.hive.druid.io.druid.client.cache.CacheConfig;
import org.apache.hive.druid.io.druid.collections.BlockingPool;
import org.apache.hive.druid.io.druid.collections.DummyBlockingPool;
import org.apache.hive.druid.io.druid.collections.DummyNonBlockingPool;
import org.apache.hive.druid.io.druid.collections.NonBlockingPool;
import org.apache.hive.druid.io.druid.guice.LazySingleton;
import org.apache.hive.druid.io.druid.guice.ManageLifecycle;
import org.apache.hive.druid.io.druid.guice.annotations.BackgroundCaching;
import org.apache.hive.druid.io.druid.guice.annotations.Global;
import org.apache.hive.druid.io.druid.guice.annotations.Merging;
import org.apache.hive.druid.io.druid.guice.annotations.Processing;
import org.apache.hive.druid.io.druid.java.util.common.concurrent.Execs;
import org.apache.hive.druid.io.druid.java.util.common.concurrent.ExecutorServiceConfig;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.query.DruidProcessingConfig;
import org.apache.hive.druid.io.druid.query.ExecutorServiceMonitor;
import org.apache.hive.druid.io.druid.server.metrics.MetricsModule;

public class RouterProcessingModule
implements Module {
    private static final Logger log = new Logger(RouterProcessingModule.class);

    public void configure(Binder binder) {
        binder.bind(ExecutorServiceConfig.class).to(DruidProcessingConfig.class);
        MetricsModule.register(binder, ExecutorServiceMonitor.class);
    }

    @Provides
    @BackgroundCaching
    @LazySingleton
    public ExecutorService getBackgroundExecutorService(CacheConfig cacheConfig) {
        if (cacheConfig.getNumBackgroundThreads() > 0) {
            log.error("numBackgroundThreads[%d] configured, that is ignored on Router", cacheConfig.getNumBackgroundThreads());
        }
        return Execs.dummy();
    }

    @Provides
    @Processing
    @ManageLifecycle
    public ExecutorService getProcessingExecutorService(DruidProcessingConfig config) {
        if (config.getNumThreadsConfigured() != -1) {
            log.error("numThreads[%d] configured, that is ignored on Router", config.getNumThreadsConfigured());
        }
        return Execs.dummy();
    }

    @Provides
    @LazySingleton
    @Global
    public NonBlockingPool<ByteBuffer> getIntermediateResultsPool() {
        return DummyNonBlockingPool.instance();
    }

    @Provides
    @LazySingleton
    @Merging
    public BlockingPool<ByteBuffer> getMergeBufferPool(DruidProcessingConfig config) {
        if (config.getNumMergeBuffersConfigured() != -1) {
            log.error("numMergeBuffers[%d] configured, that is ignored on Router", config.getNumMergeBuffersConfigured());
        }
        return DummyBlockingPool.instance();
    }
}

