/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.guice;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import org.apache.hive.druid.io.druid.client.coordinator.Coordinator;
import org.apache.hive.druid.io.druid.client.coordinator.CoordinatorSelectorConfig;
import org.apache.hive.druid.io.druid.curator.discovery.ServerDiscoveryFactory;
import org.apache.hive.druid.io.druid.curator.discovery.ServerDiscoverySelector;
import org.apache.hive.druid.io.druid.discovery.DruidLeaderClient;
import org.apache.hive.druid.io.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.hive.druid.io.druid.guice.JsonConfigProvider;
import org.apache.hive.druid.io.druid.guice.ManageLifecycle;
import org.apache.hive.druid.io.druid.guice.annotations.EscalatedGlobal;
import org.apache.hive.druid.io.druid.java.util.http.client.HttpClient;

public class CoordinatorDiscoveryModule
implements Module {
    public void configure(Binder binder) {
        JsonConfigProvider.bind(binder, "druid.selectors.coordinator", CoordinatorSelectorConfig.class);
    }

    @Provides
    @Coordinator
    @ManageLifecycle
    public ServerDiscoverySelector getServiceProvider(CoordinatorSelectorConfig config, ServerDiscoveryFactory serverDiscoveryFactory) {
        return serverDiscoveryFactory.createSelector(config.getServiceName());
    }

    @Provides
    @Coordinator
    @ManageLifecycle
    public DruidLeaderClient getLeaderHttpClient(@EscalatedGlobal HttpClient httpClient, DruidNodeDiscoveryProvider druidNodeDiscoveryProvider, @Coordinator ServerDiscoverySelector serverDiscoverySelector) {
        return new DruidLeaderClient(httpClient, druidNodeDiscoveryProvider, "coordinator", "/druid/coordinator/v1/leader", serverDiscoverySelector);
    }
}

