/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.curator;

import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;

public class CuratorUtils {
    public static final int DEFAULT_MAX_ZNODE_BYTES = 524288;
    private static final Logger log = new Logger(CuratorUtils.class);

    public static void createIfNotExists(CuratorFramework curatorFramework, String path, CreateMode mode, byte[] rawBytes, int maxZnodeBytes) throws Exception {
        CuratorUtils.verifySize(path, rawBytes, maxZnodeBytes);
        if (curatorFramework.checkExists().forPath(path) == null) {
            try {
                ((ACLBackgroundPathAndBytesable)curatorFramework.create().creatingParentsIfNeeded().withMode(mode)).forPath(path, rawBytes);
            }
            catch (KeeperException.NodeExistsException e) {
                log.info("Skipping create path[%s], since it already exists.", path);
            }
        }
    }

    public static void createOrSet(CuratorFramework curatorFramework, String path, CreateMode mode, byte[] rawBytes, int maxZnodeBytes) throws Exception {
        CuratorUtils.verifySize(path, rawBytes, maxZnodeBytes);
        boolean created = false;
        if (curatorFramework.checkExists().forPath(path) == null) {
            try {
                ((ACLBackgroundPathAndBytesable)curatorFramework.create().creatingParentsIfNeeded().withMode(mode)).forPath(path, rawBytes);
                created = true;
            }
            catch (KeeperException.NodeExistsException e) {
                log.debug("Path [%s] created while we were running, will setData instead.", path);
            }
        }
        if (!created) {
            try {
                curatorFramework.setData().forPath(path, rawBytes);
            }
            catch (KeeperException.NoNodeException e) {
                log.warn("Someone deleted path[%s] while we were trying to set it. Leaving it deleted.", path);
            }
        }
    }

    private static void verifySize(String path, byte[] rawBytes, int maxZnodeBytes) {
        if (rawBytes.length > maxZnodeBytes) {
            throw new IAE("Length of raw bytes for znode[%s] too large[%,d > %,d]", path, rawBytes.length, maxZnodeBytes);
        }
    }
}

