/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.filter;

import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseHeaders;
import org.asynchttpclient.HttpResponseStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncHandlerWrapper<T>
implements AsyncHandler<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncHandlerWrapper.class);
    private final AsyncHandler<T> asyncHandler;
    private final Semaphore available;
    private final AtomicBoolean complete = new AtomicBoolean(false);

    public AsyncHandlerWrapper(AsyncHandler<T> asyncHandler, Semaphore available) {
        this.asyncHandler = asyncHandler;
        this.available = available;
    }

    private void complete() {
        if (this.complete.compareAndSet(false, true)) {
            this.available.release();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Current Throttling Status after onThrowable {}", (Object)this.available.availablePermits());
        }
    }

    @Override
    public void onThrowable(Throwable t) {
        try {
            this.asyncHandler.onThrowable(t);
        }
        finally {
            this.complete();
        }
    }

    @Override
    public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
        return this.asyncHandler.onBodyPartReceived(bodyPart);
    }

    @Override
    public AsyncHandler.State onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
        return this.asyncHandler.onStatusReceived(responseStatus);
    }

    @Override
    public AsyncHandler.State onHeadersReceived(HttpResponseHeaders headers) throws Exception {
        return this.asyncHandler.onHeadersReceived(headers);
    }

    @Override
    public T onCompleted() throws Exception {
        try {
            T t = this.asyncHandler.onCompleted();
            return t;
        }
        finally {
            this.complete();
        }
    }
}

