/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.linq4j.tree;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.Evaluator;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.Expression;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.ExpressionType;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.ExpressionWriter;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.Expressions;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.Shuttle;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.Types;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.Visitor;

public class MethodCallExpression
extends Expression {
    public final Method method;
    public final Expression targetExpression;
    public final List<Expression> expressions;
    private int hash;

    MethodCallExpression(Type returnType, Method method, Expression targetExpression, List<Expression> expressions) {
        super(ExpressionType.Call, returnType);
        assert (expressions != null) : "expressions should not be null";
        assert (method != null) : "method should not be null";
        assert (targetExpression == null == Modifier.isStatic(method.getModifiers()));
        assert (Types.toClass(returnType) == method.getReturnType());
        this.method = method;
        this.targetExpression = targetExpression;
        this.expressions = expressions;
    }

    MethodCallExpression(Method method, Expression targetExpression, List<Expression> expressions) {
        this(method.getGenericReturnType(), method, targetExpression, expressions);
    }

    @Override
    public Expression accept(Shuttle shuttle) {
        shuttle = shuttle.preVisit(this);
        Expression targetExpression = Expressions.accept(this.targetExpression, shuttle);
        List<Expression> expressions = Expressions.acceptExpressions(this.expressions, shuttle);
        return shuttle.visit(this, targetExpression, expressions);
    }

    @Override
    public <R> R accept(Visitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Object evaluate(Evaluator evaluator) {
        Object target = this.targetExpression == null ? null : this.targetExpression.evaluate(evaluator);
        Object[] args = new Object[this.expressions.size()];
        for (int i = 0; i < this.expressions.size(); ++i) {
            Expression expression = this.expressions.get(i);
            args[i] = expression.evaluate(evaluator);
        }
        try {
            return this.method.invoke(target, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("error while evaluating " + this, e);
        }
    }

    @Override
    void accept(ExpressionWriter writer, int lprec, int rprec) {
        if (writer.requireParentheses(this, lprec, rprec)) {
            return;
        }
        if (this.targetExpression != null) {
            this.targetExpression.accept(writer, lprec, this.nodeType.lprec);
        } else {
            writer.append(this.method.getDeclaringClass());
        }
        writer.append('.').append(this.method.getName()).append('(');
        int k = 0;
        for (Expression expression : this.expressions) {
            if (k++ > 0) {
                writer.append(", ");
            }
            expression.accept(writer, 0, 0);
        }
        writer.append(')');
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MethodCallExpression that = (MethodCallExpression)o;
        if (!this.expressions.equals(that.expressions)) {
            return false;
        }
        if (!this.method.equals(that.method)) {
            return false;
        }
        return !(this.targetExpression != null ? !this.targetExpression.equals(that.targetExpression) : that.targetExpression != null);
    }

    @Override
    public int hashCode() {
        int result = this.hash;
        if (result == 0) {
            result = Objects.hash(new Object[]{this.nodeType, this.type, this.method, this.targetExpression, this.expressions});
            if (result == 0) {
                result = 1;
            }
            this.hash = result;
        }
        return result;
    }
}

