/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.linq4j.tree;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.ExpressionWriter;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.MemberDeclaration;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.Shuttle;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.Types;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.Visitor;

public class ConstructorDeclaration
extends MemberDeclaration {
    public final int modifier;
    public final Type resultType;
    public final List<ParameterExpression> parameters;
    public final BlockStatement body;
    private int hash;

    public ConstructorDeclaration(int modifier, Type declaredAgainst, List<ParameterExpression> parameters, BlockStatement body) {
        assert (parameters != null) : "parameters should not be null";
        assert (body != null) : "body should not be null";
        assert (declaredAgainst != null) : "declaredAgainst should not be null";
        this.modifier = modifier;
        this.resultType = declaredAgainst;
        this.parameters = parameters;
        this.body = body;
    }

    @Override
    public MemberDeclaration accept(Shuttle shuttle) {
        shuttle = shuttle.preVisit(this);
        BlockStatement body = this.body.accept(shuttle);
        return shuttle.visit(this, body);
    }

    @Override
    public <R> R accept(Visitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void accept(ExpressionWriter writer) {
        String modifiers = Modifier.toString(this.modifier);
        writer.append(modifiers);
        if (!modifiers.isEmpty()) {
            writer.append(' ');
        }
        writer.append(this.resultType).list("(", ", ", ")", Lists.transform(this.parameters, new Function<ParameterExpression, String>(){

            @Override
            public String apply(ParameterExpression parameter) {
                String modifiers = Modifier.toString(parameter.modifier);
                return modifiers + (modifiers.isEmpty() ? "" : " ") + Types.className(parameter.getType()) + " " + parameter.name;
            }
        })).append(' ').append(this.body);
        writer.newlineAndIndent();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstructorDeclaration that = (ConstructorDeclaration)o;
        if (this.modifier != that.modifier) {
            return false;
        }
        if (!this.body.equals(that.body)) {
            return false;
        }
        if (!this.parameters.equals(that.parameters)) {
            return false;
        }
        return this.resultType.equals(that.resultType);
    }

    public int hashCode() {
        int result = this.hash;
        if (result == 0) {
            result = Objects.hash(this.modifier, this.resultType, this.parameters, this.body);
            if (result == 0) {
                result = 1;
            }
            this.hash = result;
        }
        return result;
    }
}

