/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.adapter.druid;

import javax.annotation.Nullable;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidExpressions;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidSqlOperatorConverter;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rex.RexCall;
import org.apache.hive.druid.org.apache.calcite.rex.RexLiteral;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperator;
import org.apache.hive.druid.org.apache.calcite.sql.fun.SqlStdOperatorTable;

public class SubstringOperatorConversion
implements DruidSqlOperatorConverter {
    @Override
    public SqlOperator calciteOperator() {
        return SqlStdOperatorTable.SUBSTRING;
    }

    @Override
    @Nullable
    public String toDruidExpression(RexNode rexNode, RelDataType rowType, DruidQuery query) {
        RexCall call = (RexCall)rexNode;
        String arg = DruidExpressions.toDruidExpression(call.getOperands().get(0), rowType, query);
        if (arg == null) {
            return null;
        }
        int index = RexLiteral.intValue(call.getOperands().get(1)) - 1;
        int length = call.getOperands().size() > 2 ? RexLiteral.intValue(call.getOperands().get(2)) : -1;
        return DruidQuery.format("substring(%s, %s, %s)", arg, DruidExpressions.numberLiteral(index), DruidExpressions.numberLiteral(length));
    }
}

