/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.storage.hdfs;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.multibindings.MapBinder;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hive.druid.com.fasterxml.jackson.core.Version;
import org.apache.hive.druid.com.fasterxml.jackson.databind.Module;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.io.druid.data.SearchableVersionedDataFinder;
import org.apache.hive.druid.io.druid.guice.Binders;
import org.apache.hive.druid.io.druid.guice.JsonConfigProvider;
import org.apache.hive.druid.io.druid.guice.LazySingleton;
import org.apache.hive.druid.io.druid.guice.LifecycleModule;
import org.apache.hive.druid.io.druid.guice.ManageLifecycle;
import org.apache.hive.druid.io.druid.initialization.DruidModule;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.storage.hdfs.HdfsDataSegmentFinder;
import org.apache.hive.druid.io.druid.storage.hdfs.HdfsDataSegmentKiller;
import org.apache.hive.druid.io.druid.storage.hdfs.HdfsDataSegmentPuller;
import org.apache.hive.druid.io.druid.storage.hdfs.HdfsDataSegmentPusher;
import org.apache.hive.druid.io.druid.storage.hdfs.HdfsDataSegmentPusherConfig;
import org.apache.hive.druid.io.druid.storage.hdfs.HdfsFileTimestampVersionFinder;
import org.apache.hive.druid.io.druid.storage.hdfs.HdfsKerberosConfig;
import org.apache.hive.druid.io.druid.storage.hdfs.HdfsLoadSpec;
import org.apache.hive.druid.io.druid.storage.hdfs.HdfsStorageAuthentication;
import org.apache.hive.druid.io.druid.storage.hdfs.tasklog.HdfsTaskLogs;
import org.apache.hive.druid.io.druid.storage.hdfs.tasklog.HdfsTaskLogsConfig;

public class HdfsStorageDruidModule
implements DruidModule {
    private static final Logger log = new Logger(HdfsStorageDruidModule.class);
    public static final String SCHEME = "hdfs";
    private Properties props = null;

    @Inject
    public void setProperties(Properties props) {
        this.props = props;
    }

    @Override
    public List<? extends Module> getJacksonModules() {
        return ImmutableList.of(new Module(){

            @Override
            public String getModuleName() {
                return "DruidHDFSStorage-" + System.identityHashCode(this);
            }

            @Override
            public Version version() {
                return Version.unknownVersion();
            }

            @Override
            public void setupModule(Module.SetupContext context) {
                context.registerSubtypes(HdfsLoadSpec.class);
            }
        });
    }

    public void configure(Binder binder) {
        MapBinder.newMapBinder((Binder)binder, String.class, SearchableVersionedDataFinder.class).addBinding((Object)SCHEME).to(HdfsFileTimestampVersionFinder.class).in(LazySingleton.class);
        Binders.dataSegmentPullerBinder(binder).addBinding((Object)SCHEME).to(HdfsDataSegmentPuller.class).in(LazySingleton.class);
        Binders.dataSegmentPusherBinder(binder).addBinding((Object)SCHEME).to(HdfsDataSegmentPusher.class).in(LazySingleton.class);
        Binders.dataSegmentKillerBinder(binder).addBinding((Object)SCHEME).to(HdfsDataSegmentKiller.class).in(LazySingleton.class);
        Binders.dataSegmentFinderBinder(binder).addBinding((Object)SCHEME).to(HdfsDataSegmentFinder.class).in(LazySingleton.class);
        Configuration conf = new Configuration();
        conf.setClassLoader(this.getClass().getClassLoader());
        ClassLoader currCtxCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            FileSystem.get((Configuration)conf);
        }
        catch (IOException ex) {
            throw Throwables.propagate(ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currCtxCl);
        }
        if (this.props != null) {
            for (String propName : this.props.stringPropertyNames()) {
                if (!propName.startsWith("hadoop.")) continue;
                conf.set(propName.substring("hadoop.".length()), this.props.getProperty(propName));
            }
        }
        binder.bind(Configuration.class).toInstance((Object)conf);
        JsonConfigProvider.bind(binder, "druid.storage", HdfsDataSegmentPusherConfig.class);
        Binders.taskLogsBinder(binder).addBinding((Object)SCHEME).to(HdfsTaskLogs.class);
        JsonConfigProvider.bind(binder, "druid.indexer.logs", HdfsTaskLogsConfig.class);
        binder.bind(HdfsTaskLogs.class).in(LazySingleton.class);
        JsonConfigProvider.bind(binder, "druid.hadoop.security.kerberos", HdfsKerberosConfig.class);
        binder.bind(HdfsStorageAuthentication.class).in(ManageLifecycle.class);
        LifecycleModule.register(binder, HdfsStorageAuthentication.class);
    }
}

