/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.storage.hdfs;

import java.io.File;
import org.apache.hadoop.fs.Path;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JacksonInject;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.io.druid.segment.loading.LoadSpec;
import org.apache.hive.druid.io.druid.segment.loading.SegmentLoadingException;
import org.apache.hive.druid.io.druid.storage.hdfs.HdfsDataSegmentPuller;

@JsonTypeName(value="hdfs")
public class HdfsLoadSpec
implements LoadSpec {
    private final Path path;
    final HdfsDataSegmentPuller puller;

    @JsonCreator
    public HdfsLoadSpec(@JacksonInject HdfsDataSegmentPuller puller, @JsonProperty(value="path", required=true) String path) {
        Preconditions.checkNotNull(path);
        this.path = new Path(path);
        this.puller = puller;
    }

    @JsonProperty(value="path")
    public final String getPathString() {
        return this.path.toString();
    }

    @Override
    public LoadSpec.LoadSpecResult loadSegment(File outDir) throws SegmentLoadingException {
        return new LoadSpec.LoadSpecResult(this.puller.getSegmentFiles(this.path, outDir).size());
    }
}

