/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordination;

import java.util.Objects;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonUnwrapped;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.server.coordination.DataSegmentChangeCallback;
import org.apache.hive.druid.io.druid.server.coordination.DataSegmentChangeHandler;
import org.apache.hive.druid.io.druid.server.coordination.DataSegmentChangeRequest;
import org.apache.hive.druid.io.druid.timeline.DataSegment;

public class SegmentChangeRequestLoad
implements DataSegmentChangeRequest {
    private final DataSegment segment;

    @JsonCreator
    public SegmentChangeRequestLoad(@JsonUnwrapped DataSegment segment) {
        this.segment = segment;
    }

    @Override
    public void go(DataSegmentChangeHandler handler, DataSegmentChangeCallback callback) {
        handler.addSegment(this.segment, callback);
    }

    @JsonProperty
    @JsonUnwrapped
    public DataSegment getSegment() {
        return this.segment;
    }

    @Override
    public String asString() {
        return StringUtils.format("LOAD: %s", this.segment.getIdentifier());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentChangeRequestLoad that = (SegmentChangeRequestLoad)o;
        return Objects.equals(this.segment, that.segment);
    }

    public int hashCode() {
        return Objects.hash(this.segment);
    }

    public String toString() {
        return "SegmentChangeRequestLoad{segment=" + this.segment + '}';
    }
}

