/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.transform;

import java.util.Objects;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JacksonInject;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.io.druid.data.input.Row;
import org.apache.hive.druid.io.druid.math.expr.Expr;
import org.apache.hive.druid.io.druid.math.expr.ExprMacroTable;
import org.apache.hive.druid.io.druid.math.expr.Parser;
import org.apache.hive.druid.io.druid.segment.transform.RowFunction;
import org.apache.hive.druid.io.druid.segment.transform.Transform;

public class ExpressionTransform
implements Transform {
    private final String name;
    private final String expression;
    private final ExprMacroTable macroTable;

    @JsonCreator
    public ExpressionTransform(@JsonProperty(value="name") String name, @JsonProperty(value="expression") String expression, @JacksonInject ExprMacroTable macroTable) {
        this.name = Preconditions.checkNotNull(name, "name");
        this.expression = Preconditions.checkNotNull(expression, "expression");
        this.macroTable = macroTable;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getExpression() {
        return this.expression;
    }

    @Override
    public RowFunction getRowFunction() {
        Expr expr = Parser.parse(this.expression, Preconditions.checkNotNull(this.macroTable, "macroTable"));
        return new ExpressionRowFunction(expr);
    }

    private static Object getValueFromRow(Row row, String column) {
        if (column.equals("__time")) {
            return row.getTimestampFromEpoch();
        }
        return row.getRaw(column);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpressionTransform that = (ExpressionTransform)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.expression, that.expression);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.expression);
    }

    public String toString() {
        return "ExpressionTransform{name='" + this.name + '\'' + ", expression='" + this.expression + '\'' + '}';
    }

    static class ExpressionRowFunction
    implements RowFunction {
        private final Expr expr;

        ExpressionRowFunction(Expr expr) {
            this.expr = expr;
        }

        @Override
        public Object eval(Row row) {
            return this.expr.eval((String name) -> ExpressionTransform.getValueFromRow(row, name)).value();
        }
    }
}

