/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.topn.types;

import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.query.dimension.ColumnSelectorStrategyFactory;
import org.apache.hive.druid.io.druid.query.topn.types.NumericTopNColumnSelectorStrategy;
import org.apache.hive.druid.io.druid.query.topn.types.StringTopNColumnSelectorStrategy;
import org.apache.hive.druid.io.druid.query.topn.types.TopNColumnSelectorStrategy;
import org.apache.hive.druid.io.druid.segment.ColumnValueSelector;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.io.druid.segment.column.ValueType;

public class TopNColumnSelectorStrategyFactory
implements ColumnSelectorStrategyFactory<TopNColumnSelectorStrategy> {
    @Override
    public TopNColumnSelectorStrategy makeColumnSelectorStrategy(ColumnCapabilities capabilities, ColumnValueSelector selector) {
        ValueType type = capabilities.getType();
        switch (type) {
            case STRING: {
                return new StringTopNColumnSelectorStrategy();
            }
            case LONG: {
                return new NumericTopNColumnSelectorStrategy.OfLong();
            }
            case FLOAT: {
                return new NumericTopNColumnSelectorStrategy.OfFloat();
            }
            case DOUBLE: {
                return new NumericTopNColumnSelectorStrategy.OfDouble();
            }
        }
        throw new IAE("Cannot create query type helper from invalid type [%s]", new Object[]{type});
    }
}

