/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.extraction;

import com.ibm.icu.text.SimpleDateFormat;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.Date;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.query.extraction.DimExtractionFn;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;

public class TimeDimExtractionFn
extends DimExtractionFn {
    private final String timeFormat;
    private final ThreadLocal<SimpleDateFormat> timeFormatter;
    private final String resultFormat;
    private final ThreadLocal<SimpleDateFormat> resultFormatter;

    @JsonCreator
    public TimeDimExtractionFn(@JsonProperty(value="timeFormat") String timeFormat, @JsonProperty(value="resultFormat") String resultFormat) {
        Preconditions.checkNotNull(timeFormat, "timeFormat must not be null");
        Preconditions.checkNotNull(resultFormat, "resultFormat must not be null");
        this.timeFormat = timeFormat;
        this.timeFormatter = ThreadLocal.withInitial(() -> {
            SimpleDateFormat formatter = new SimpleDateFormat(this.timeFormat);
            formatter.setLenient(true);
            return formatter;
        });
        this.resultFormat = resultFormat;
        this.resultFormatter = ThreadLocal.withInitial(() -> {
            SimpleDateFormat formatter = new SimpleDateFormat(this.resultFormat);
            return formatter;
        });
    }

    @Override
    public byte[] getCacheKey() {
        byte[] timeFormatBytes = StringUtils.toUtf8(this.timeFormat);
        return ByteBuffer.allocate(1 + timeFormatBytes.length).put((byte)0).put(timeFormatBytes).array();
    }

    @Override
    @Nullable
    public String apply(@Nullable String dimValue) {
        Date date;
        if (Strings.isNullOrEmpty(dimValue)) {
            return null;
        }
        try {
            date = this.timeFormatter.get().parse(dimValue);
        }
        catch (ParseException e) {
            return dimValue;
        }
        return this.resultFormatter.get().format(date);
    }

    @JsonProperty(value="timeFormat")
    public String getTimeFormat() {
        return this.timeFormat;
    }

    @JsonProperty(value="resultFormat")
    public String getResultFormat() {
        return this.resultFormat;
    }

    @Override
    public boolean preservesOrdering() {
        return false;
    }

    @Override
    public ExtractionFn.ExtractionType getExtractionType() {
        return ExtractionFn.ExtractionType.MANY_TO_ONE;
    }

    public String toString() {
        return "TimeDimExtractionFn{timeFormat='" + this.timeFormat + '\'' + ", resultFormat='" + this.resultFormat + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeDimExtractionFn that = (TimeDimExtractionFn)o;
        if (!this.resultFormat.equals(that.resultFormat)) {
            return false;
        }
        return this.timeFormat.equals(that.timeFormat);
    }

    public int hashCode() {
        int result = this.timeFormat.hashCode();
        result = 31 * result + this.resultFormat.hashCode();
        return result;
    }
}

