/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation.hyperloglog;

import java.nio.ByteBuffer;
import org.apache.commons.codec.binary.Base64;
import org.apache.hive.druid.io.druid.data.input.InputRow;
import org.apache.hive.druid.io.druid.hll.HyperLogLogCollector;
import org.apache.hive.druid.io.druid.hll.HyperLogLogHash;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.query.aggregation.hyperloglog.HyperUniquesSerde;
import org.apache.hive.druid.io.druid.segment.serde.ComplexMetricExtractor;

public class PreComputedHyperUniquesSerde
extends HyperUniquesSerde {
    public PreComputedHyperUniquesSerde(HyperLogLogHash hyperLogLogHash) {
        super(hyperLogLogHash);
    }

    @Override
    public ComplexMetricExtractor getExtractor() {
        return new ComplexMetricExtractor(){

            public Class<HyperLogLogCollector> extractedClass() {
                return HyperLogLogCollector.class;
            }

            @Override
            public HyperLogLogCollector extractValue(InputRow inputRow, String metricName) {
                Object rawValue = inputRow.getRaw(metricName);
                if (rawValue == null) {
                    return HyperLogLogCollector.makeLatestCollector();
                }
                if (rawValue instanceof HyperLogLogCollector) {
                    return (HyperLogLogCollector)rawValue;
                }
                if (rawValue instanceof byte[]) {
                    return HyperLogLogCollector.makeLatestCollector().fold(ByteBuffer.wrap((byte[])rawValue));
                }
                if (rawValue instanceof String) {
                    return HyperLogLogCollector.makeLatestCollector().fold(ByteBuffer.wrap(Base64.decodeBase64((String)((String)rawValue))));
                }
                throw new ISE("Object is not of a type[%s] that can be deserialized to HyperLogLog.", rawValue.getClass());
            }
        };
    }
}

