/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.guice.http;

import javax.validation.constraints.Min;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.joda.time.Duration;
import org.joda.time.Period;

public class DruidHttpClientConfig {
    private final String DEFAULT_COMPRESSION_CODEC = "gzip";
    @JsonProperty
    @Min(value=0L)
    private int numConnections = 20;
    @JsonProperty
    private Period readTimeout = new Period((Object)"PT15M");
    @JsonProperty
    @Min(value=1L)
    private int numMaxThreads = Math.max(10, Runtime.getRuntime().availableProcessors() * 17 / 16 + 2) + 30;
    @JsonProperty
    @Min(value=1L)
    private int numRequestsQueued = 1024;
    @JsonProperty
    private String compressionCodec = "gzip";
    @JsonProperty
    private int requestBuffersize = 8192;

    public int getNumConnections() {
        return this.numConnections;
    }

    public Duration getReadTimeout() {
        return this.readTimeout == null ? null : this.readTimeout.toStandardDuration();
    }

    public int getNumMaxThreads() {
        return this.numMaxThreads;
    }

    public String getCompressionCodec() {
        return this.compressionCodec;
    }

    public int getNumRequestsQueued() {
        return this.numRequestsQueued;
    }

    public int getRequestBuffersize() {
        return this.requestBuffersize;
    }
}

