/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.client.selector;

import java.util.Comparator;
import java.util.HashMap;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JacksonInject;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.io.druid.client.selector.AbstractTierSelectorStrategy;
import org.apache.hive.druid.io.druid.client.selector.CustomTierSelectorStrategyConfig;
import org.apache.hive.druid.io.druid.client.selector.ServerSelectorStrategy;

public class CustomTierSelectorStrategy
extends AbstractTierSelectorStrategy {
    private final Comparator<Integer> comparator;

    @JsonCreator
    public CustomTierSelectorStrategy(@JacksonInject ServerSelectorStrategy serverSelectorStrategy, @JacksonInject CustomTierSelectorStrategyConfig config) {
        super(serverSelectorStrategy);
        HashMap<Integer, Integer> lookup = Maps.newHashMap();
        int pos = 0;
        for (Integer integer : config.getPriorities()) {
            lookup.put(integer, pos);
            ++pos;
        }
        this.comparator = Comparator.comparingInt(lookup::get);
    }

    @Override
    public Comparator<Integer> getComparator() {
        return this.comparator;
    }
}

