/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.roaringbitmap;

import org.apache.hive.druid.org.roaringbitmap.ArrayContainer;
import org.apache.hive.druid.org.roaringbitmap.ArrayContainerShortIterator;
import org.apache.hive.druid.org.roaringbitmap.BitmapContainer;
import org.apache.hive.druid.org.roaringbitmap.BitmapContainerShortIterator;
import org.apache.hive.druid.org.roaringbitmap.Container;
import org.apache.hive.druid.org.roaringbitmap.IntIterator;
import org.apache.hive.druid.org.roaringbitmap.RoaringBitmap;
import org.apache.hive.druid.org.roaringbitmap.RunContainer;
import org.apache.hive.druid.org.roaringbitmap.RunContainerShortIterator;
import org.apache.hive.druid.org.roaringbitmap.ShortIterator;
import org.apache.hive.druid.org.roaringbitmap.Util;

public class IntIteratorFlyweight
implements IntIterator {
    private int hs;
    private ShortIterator iter;
    private ArrayContainerShortIterator arrIter = new ArrayContainerShortIterator();
    private BitmapContainerShortIterator bitmapIter = new BitmapContainerShortIterator();
    private RunContainerShortIterator runIter = new RunContainerShortIterator();
    private int pos;
    private RoaringBitmap roaringBitmap = null;

    public IntIteratorFlyweight() {
    }

    public IntIteratorFlyweight(RoaringBitmap r) {
        this.wrap(r);
    }

    public void wrap(RoaringBitmap r) {
        this.hs = 0;
        this.pos = 0;
        this.roaringBitmap = r;
        this.nextContainer();
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.roaringBitmap.highLowContainer.size();
    }

    private void nextContainer() {
        if (this.pos < this.roaringBitmap.highLowContainer.size()) {
            Container container = this.roaringBitmap.highLowContainer.getContainerAtIndex(this.pos);
            if (container instanceof BitmapContainer) {
                this.bitmapIter.wrap(((BitmapContainer)container).bitmap);
                this.iter = this.bitmapIter;
            } else if (container instanceof ArrayContainer) {
                this.arrIter.wrap((ArrayContainer)container);
                this.iter = this.arrIter;
            } else {
                this.runIter.wrap((RunContainer)container);
                this.iter = this.runIter;
            }
            this.hs = Util.toIntUnsigned(this.roaringBitmap.highLowContainer.getKeyAtIndex(this.pos)) << 16;
        }
    }

    @Override
    public int next() {
        int x = this.iter.nextAsInt() | this.hs;
        if (!this.iter.hasNext()) {
            ++this.pos;
            this.nextContainer();
        }
        return x;
    }

    @Override
    public IntIterator clone() {
        try {
            IntIteratorFlyweight x = (IntIteratorFlyweight)super.clone();
            x.iter = this.iter.clone();
            return x;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

