/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.rex;

import java.util.List;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptTable;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rex.RexBiVisitor;
import org.apache.hive.druid.org.apache.calcite.rex.RexInputRef;
import org.apache.hive.druid.org.apache.calcite.rex.RexVisitor;
import org.apache.hive.druid.org.apache.calcite.sql.SqlKind;

public class RexTableInputRef
extends RexInputRef {
    private final RelTableRef tableRef;

    private RexTableInputRef(RelTableRef tableRef, int index, RelDataType type) {
        super(index, type);
        this.tableRef = tableRef;
        this.digest = tableRef.toString() + ".$" + index;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof RexTableInputRef && this.tableRef.equals(((RexTableInputRef)obj).tableRef) && this.index == ((RexTableInputRef)obj).index;
    }

    @Override
    public int hashCode() {
        return this.digest.hashCode();
    }

    public RelTableRef getTableRef() {
        return this.tableRef;
    }

    public List<String> getQualifiedName() {
        return this.tableRef.getQualifiedName();
    }

    public int getIdentifier() {
        return this.tableRef.getEntityNumber();
    }

    public static RexTableInputRef of(RelTableRef tableRef, int index, RelDataType type) {
        return new RexTableInputRef(tableRef, index, type);
    }

    public static RexTableInputRef of(RelTableRef tableRef, RexInputRef ref) {
        return new RexTableInputRef(tableRef, ref.getIndex(), ref.getType());
    }

    @Override
    public <R> R accept(RexVisitor<R> visitor) {
        return visitor.visitTableInputRef(this);
    }

    @Override
    public <R, P> R accept(RexBiVisitor<R, P> visitor, P arg) {
        return visitor.visitTableInputRef(this, arg);
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.TABLE_INPUT_REF;
    }

    public static class RelTableRef
    implements Comparable<RelTableRef> {
        private final RelOptTable table;
        private final int entityNumber;
        private final String digest;

        private RelTableRef(RelOptTable table, int entityNumber) {
            this.table = table;
            this.entityNumber = entityNumber;
            this.digest = table.getQualifiedName() + ".#" + entityNumber;
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof RelTableRef && this.table.getQualifiedName().equals(((RelTableRef)obj).getQualifiedName()) && this.entityNumber == ((RelTableRef)obj).entityNumber;
        }

        public int hashCode() {
            return this.digest.hashCode();
        }

        public RelOptTable getTable() {
            return this.table;
        }

        public List<String> getQualifiedName() {
            return this.table.getQualifiedName();
        }

        public int getEntityNumber() {
            return this.entityNumber;
        }

        public String toString() {
            return this.digest;
        }

        public static RelTableRef of(RelOptTable table, int entityNumber) {
            return new RelTableRef(table, entityNumber);
        }

        @Override
        public int compareTo(RelTableRef o) {
            return this.digest.compareTo(o.digest);
        }
    }
}

