/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.adapter.elasticsearch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.HashMultimap;
import org.apache.hive.druid.com.google.common.collect.Multimap;
import org.apache.hive.druid.org.apache.calcite.adapter.elasticsearch.ElasticsearchRel;
import org.apache.hive.druid.org.apache.calcite.adapter.elasticsearch.ElasticsearchRules;
import org.apache.hive.druid.org.apache.calcite.adapter.elasticsearch.MapProjectionFieldVisitor;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptCluster;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptCost;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptPlanner;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptUtil;
import org.apache.hive.druid.org.apache.calcite.plan.RelTraitSet;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.core.Filter;
import org.apache.hive.druid.org.apache.calcite.rel.core.Project;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.hive.druid.org.apache.calcite.rex.RexCall;
import org.apache.hive.druid.org.apache.calcite.rex.RexInputRef;
import org.apache.hive.druid.org.apache.calcite.rex.RexLiteral;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.util.JsonBuilder;
import org.apache.hive.druid.org.apache.calcite.util.Pair;

public class ElasticsearchFilter
extends Filter
implements ElasticsearchRel {
    public ElasticsearchFilter(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RexNode condition) {
        super(cluster, traitSet, child, condition);
        assert (this.getConvention() == ElasticsearchRel.CONVENTION);
        assert (this.getConvention() == child.getConvention());
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.1);
    }

    @Override
    public Filter copy(RelTraitSet relTraitSet, RelNode input, RexNode condition) {
        return new ElasticsearchFilter(this.getCluster(), relTraitSet, input, condition);
    }

    @Override
    public void implement(ElasticsearchRel.Implementor implementor) {
        List<String> fieldNames;
        implementor.visitChild(0, this.getInput());
        if (this.input instanceof Project) {
            List<RexNode> projects = ((Project)this.input).getProjects();
            fieldNames = new ArrayList<String>(projects.size());
            for (RexNode project : projects) {
                String name = project.accept(MapProjectionFieldVisitor.INSTANCE);
                fieldNames.add(name);
            }
        } else {
            fieldNames = ElasticsearchRules.elasticsearchFieldNames(this.getRowType());
        }
        Translator translator = new Translator(fieldNames);
        String match = translator.translateMatch(this.condition);
        implementor.add(match);
    }

    static class Translator {
        final JsonBuilder builder = new JsonBuilder();
        final Multimap<String, Pair<String, RexLiteral>> multimap = HashMultimap.create();
        final Map<String, RexLiteral> eqMap = new LinkedHashMap<String, RexLiteral>();
        private final List<String> fieldNames;

        Translator(List<String> fieldNames) {
            this.fieldNames = fieldNames;
        }

        private String translateMatch(RexNode condition) {
            LinkedHashMap<String, Object> filterMap = new LinkedHashMap<String, Object>();
            filterMap.put("filter", this.translateOr(condition));
            Map<String, Object> map = this.builder.map();
            map.put("constant_score", filterMap);
            return "\"query\" : " + this.builder.toJsonString(map).replaceAll("\\s+", "").toLowerCase(Locale.ROOT);
        }

        private Object translateOr(RexNode condition) {
            ArrayList<Map<Object, Object>> list = new ArrayList<Map<Object, Object>>();
            List<RexNode> orNodes = RelOptUtil.disjunctions(condition);
            for (RexNode node : orNodes) {
                List<Map<String, Object>> andNodes = this.translateAnd(node);
                if (andNodes.size() > 0) {
                    HashMap<String, List<Map<String, Object>>> andClause = new HashMap<String, List<Map<String, Object>>>();
                    andClause.put("must", andNodes);
                    LinkedHashMap<String, HashMap<String, List<Map<String, Object>>>> filterEvaluator = new LinkedHashMap<String, HashMap<String, List<Map<String, Object>>>>();
                    filterEvaluator.put("bool", andClause);
                    list.add(filterEvaluator);
                    continue;
                }
                list.add(andNodes.get(0));
            }
            if (orNodes.size() > 1) {
                Map<String, Object> map = this.builder.map();
                map.put("should", list);
                LinkedHashMap<String, Map<String, Object>> filterEvaluator = new LinkedHashMap<String, Map<String, Object>>();
                filterEvaluator.put("bool", map);
                return filterEvaluator;
            }
            return list.get(0);
        }

        private void addPredicate(Map<String, Object> map, String op, Object v) {
            if (map.containsKey(op) && this.stronger(op, map.get(op), v)) {
                return;
            }
            map.put(op, v);
        }

        private List<Map<String, Object>> translateAnd(RexNode node0) {
            HashMap map;
            this.eqMap.clear();
            this.multimap.clear();
            for (RexNode node : RelOptUtil.conjunctions(node0)) {
                this.translateMatch2(node);
            }
            ArrayList<Map<String, Object>> filters = new ArrayList<Map<String, Object>>();
            for (Map.Entry<String, RexLiteral> entry : this.eqMap.entrySet()) {
                this.multimap.removeAll(entry.getKey());
                HashMap<String, Object> filter = new HashMap<String, Object>();
                filter.put(entry.getKey(), Translator.literalValue(entry.getValue()));
                map = new HashMap();
                map.put("term", filter);
                filters.add(map);
            }
            for (Map.Entry<String, Object> entry : this.multimap.asMap().entrySet()) {
                Map<String, Object> map2 = this.builder.map();
                map = new HashMap();
                for (Pair s : (Collection)entry.getValue()) {
                    if (!((String)s.left).equals("not")) {
                        this.addPredicate(map2, (String)s.left, Translator.literalValue((RexLiteral)s.right));
                        HashMap<String, Map<String, Object>> filter = new HashMap<String, Map<String, Object>>();
                        filter.put(entry.getKey(), map2);
                        map.put("range", filter);
                        continue;
                    }
                    map2.put(entry.getKey(), Translator.literalValue((RexLiteral)s.right));
                    HashMap<String, Map<String, Object>> termMap = new HashMap<String, Map<String, Object>>();
                    termMap.put("term", map2);
                    map.put("not", termMap);
                }
                filters.add(map);
            }
            return filters;
        }

        private boolean stronger(String key, Object v0, Object v1) {
            if (key.equals("lt") || key.equals("lte")) {
                if (v0 instanceof Number && v1 instanceof Number) {
                    return ((Number)v0).doubleValue() < ((Number)v1).doubleValue();
                }
                if (v0 instanceof String && v1 instanceof String) {
                    return v0.toString().compareTo(v1.toString()) < 0;
                }
            }
            if (key.equals("gt") || key.equals("gte")) {
                return this.stronger("lt", v1, v0);
            }
            return false;
        }

        private static Object literalValue(RexLiteral literal) {
            return literal.getValue2();
        }

        private Void translateMatch2(RexNode node) {
            switch (node.getKind()) {
                case EQUALS: {
                    return this.translateBinary(null, null, (RexCall)node);
                }
                case LESS_THAN: {
                    return this.translateBinary("lt", "gt", (RexCall)node);
                }
                case LESS_THAN_OR_EQUAL: {
                    return this.translateBinary("lte", "gte", (RexCall)node);
                }
                case NOT_EQUALS: {
                    return this.translateBinary("not", "not", (RexCall)node);
                }
                case GREATER_THAN: {
                    return this.translateBinary("gt", "lt", (RexCall)node);
                }
                case GREATER_THAN_OR_EQUAL: {
                    return this.translateBinary("gte", "lte", (RexCall)node);
                }
            }
            throw new AssertionError((Object)("cannot translate " + node));
        }

        private Void translateBinary(String op, String rop, RexCall call) {
            RexNode right;
            RexNode left = (RexNode)call.operands.get(0);
            boolean b = this.translateBinary2(op, left, right = (RexNode)call.operands.get(1));
            if (b) {
                return null;
            }
            b = this.translateBinary2(rop, right, left);
            if (b) {
                return null;
            }
            throw new AssertionError((Object)("cannot translate op " + op + " call " + call));
        }

        private boolean translateBinary2(String op, RexNode left, RexNode right) {
            switch (right.getKind()) {
                case LITERAL: {
                    break;
                }
                default: {
                    return false;
                }
            }
            RexLiteral rightLiteral = (RexLiteral)right;
            switch (left.getKind()) {
                case INPUT_REF: {
                    RexInputRef left1 = (RexInputRef)left;
                    String name = this.fieldNames.get(left1.getIndex());
                    this.translateOp2(op, name, rightLiteral);
                    return true;
                }
                case CAST: {
                    return this.translateBinary2(op, (RexNode)((RexCall)left).operands.get(0), right);
                }
                case OTHER_FUNCTION: {
                    String itemName = ElasticsearchRules.isItem((RexCall)left);
                    if (itemName == null) break;
                    this.translateOp2(op, itemName, rightLiteral);
                    return true;
                }
            }
            return false;
        }

        private void translateOp2(String op, String name, RexLiteral right) {
            if (op == null) {
                this.eqMap.put(name, right);
            } else {
                this.multimap.put(name, Pair.of(op, right));
            }
        }
    }
}

