/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.adapter.druid;

import java.util.Map;
import java.util.TimeZone;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidExpressions;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidSqlOperatorConverter;
import org.apache.hive.druid.org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rex.RexCall;
import org.apache.hive.druid.org.apache.calcite.rex.RexLiteral;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperator;
import org.apache.hive.druid.org.apache.calcite.sql.fun.SqlStdOperatorTable;

public class ExtractOperatorConversion
implements DruidSqlOperatorConverter {
    private static final Map<TimeUnitRange, String> EXTRACT_UNIT_MAP = ImmutableMap.builder().put(TimeUnitRange.SECOND, "SECOND").put(TimeUnitRange.MINUTE, "MINUTE").put(TimeUnitRange.HOUR, "HOUR").put(TimeUnitRange.DAY, "DAY").put(TimeUnitRange.DOW, "DOW").put(TimeUnitRange.DOY, "DOY").put(TimeUnitRange.WEEK, "WEEK").put(TimeUnitRange.MONTH, "MONTH").put(TimeUnitRange.QUARTER, "QUARTER").put(TimeUnitRange.YEAR, "YEAR").build();

    @Override
    public SqlOperator calciteOperator() {
        return SqlStdOperatorTable.EXTRACT;
    }

    @Override
    public String toDruidExpression(RexNode rexNode, RelDataType rowType, DruidQuery query) {
        RexCall call = (RexCall)rexNode;
        RexLiteral flag = (RexLiteral)call.getOperands().get(0);
        TimeUnitRange calciteUnit = (TimeUnitRange)flag.getValue();
        RexNode arg = call.getOperands().get(1);
        String input = DruidExpressions.toDruidExpression(arg, rowType, query);
        if (input == null) {
            return null;
        }
        String druidUnit = EXTRACT_UNIT_MAP.get(calciteUnit);
        if (druidUnit == null) {
            return null;
        }
        return DruidExpressions.applyTimeExtract(input, druidUnit, TimeZone.getTimeZone(query.getConnectionConfig().timeZone()));
    }
}

