/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.resolver;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import org.apache.hive.druid.io.netty.resolver.AddressResolver;
import org.apache.hive.druid.io.netty.resolver.InetSocketAddressResolver;
import org.apache.hive.druid.io.netty.resolver.SimpleNameResolver;
import org.apache.hive.druid.io.netty.util.concurrent.EventExecutor;
import org.apache.hive.druid.io.netty.util.concurrent.Future;
import org.apache.hive.druid.io.netty.util.concurrent.Promise;
import org.apache.hive.druid.io.netty.util.internal.SocketUtils2;

public abstract class InetNameResolver
extends SimpleNameResolver<InetAddress> {
    private final InetAddress loopbackAddress = SocketUtils2.loopbackAddress();
    private volatile AddressResolver<InetSocketAddress> addressResolver;

    protected InetNameResolver(EventExecutor executor) {
        super(executor);
    }

    protected InetAddress loopbackAddress() {
        return this.loopbackAddress;
    }

    @Override
    public Future<InetAddress> resolve(String inetHost, Promise<InetAddress> promise) {
        if (inetHost == null || inetHost.isEmpty()) {
            return promise.setSuccess(this.loopbackAddress());
        }
        return super.resolve(inetHost, promise);
    }

    @Override
    public Future<List<InetAddress>> resolveAll(String inetHost, Promise<List<InetAddress>> promise) {
        if (inetHost == null || inetHost.isEmpty()) {
            return promise.setSuccess(Collections.singletonList(this.loopbackAddress()));
        }
        return super.resolveAll(inetHost, promise);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddressResolver<InetSocketAddress> asAddressResolver() {
        InetSocketAddressResolver result = this.addressResolver;
        if (result == null) {
            InetNameResolver inetNameResolver = this;
            synchronized (inetNameResolver) {
                result = this.addressResolver;
                if (result == null) {
                    this.addressResolver = result = new InetSocketAddressResolver(this.executor(), this);
                }
            }
        }
        return result;
    }
}

