/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.io.druid.client.DirectDruidClient;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.SequenceWrapper;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.io.druid.query.DruidMetrics;
import org.apache.hive.druid.io.druid.query.GenericQueryMetricsFactory;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryInterruptedException;
import org.apache.hive.druid.io.druid.query.QueryMetrics;
import org.apache.hive.druid.io.druid.query.QueryPlus;
import org.apache.hive.druid.io.druid.query.QuerySegmentWalker;
import org.apache.hive.druid.io.druid.query.QueryToolChest;
import org.apache.hive.druid.io.druid.query.QueryToolChestWarehouse;
import org.apache.hive.druid.io.druid.server.QueryStats;
import org.apache.hive.druid.io.druid.server.RequestLogLine;
import org.apache.hive.druid.io.druid.server.log.RequestLogger;
import org.apache.hive.druid.io.druid.server.security.Access;
import org.apache.hive.druid.io.druid.server.security.AuthenticationResult;
import org.apache.hive.druid.io.druid.server.security.AuthorizationUtils;
import org.apache.hive.druid.io.druid.server.security.AuthorizerMapper;

public class QueryLifecycle {
    private static final Logger log = new Logger(QueryLifecycle.class);
    private final QueryToolChestWarehouse warehouse;
    private final QuerySegmentWalker texasRanger;
    private final GenericQueryMetricsFactory queryMetricsFactory;
    private final ServiceEmitter emitter;
    private final RequestLogger requestLogger;
    private final AuthorizerMapper authorizerMapper;
    private final long startMs;
    private final long startNs;
    private State state = State.NEW;
    private AuthenticationResult authenticationResult;
    private QueryToolChest toolChest;
    private QueryPlus queryPlus;

    public QueryLifecycle(QueryToolChestWarehouse warehouse, QuerySegmentWalker texasRanger, GenericQueryMetricsFactory queryMetricsFactory, ServiceEmitter emitter, RequestLogger requestLogger, AuthorizerMapper authorizerMapper, long startMs, long startNs) {
        this.warehouse = warehouse;
        this.texasRanger = texasRanger;
        this.queryMetricsFactory = queryMetricsFactory;
        this.emitter = emitter;
        this.requestLogger = requestLogger;
        this.authorizerMapper = authorizerMapper;
        this.startMs = startMs;
        this.startNs = startNs;
    }

    public <T> Sequence<T> runSimple(Query<T> query, AuthenticationResult authenticationResult, final @Nullable String remoteAddress) {
        Sequence results;
        this.initialize(query);
        try {
            Access access = this.authorize(authenticationResult);
            if (!access.isAllowed()) {
                throw new ISE("Unauthorized", new Object[0]);
            }
            QueryResponse queryResponse = this.execute();
            results = queryResponse.getResults();
        }
        catch (Throwable e) {
            this.emitLogsAndMetrics(e, remoteAddress, -1L);
            throw e;
        }
        return Sequences.wrap(results, new SequenceWrapper(){

            @Override
            public void after(boolean isDone, Throwable thrown) throws Exception {
                QueryLifecycle.this.emitLogsAndMetrics(thrown, remoteAddress, -1L);
            }
        });
    }

    public void initialize(Query baseQuery) {
        this.transition(State.NEW, State.INITIALIZED);
        String queryId = baseQuery.getId();
        if (Strings.isNullOrEmpty(queryId)) {
            queryId = UUID.randomUUID().toString();
        }
        this.queryPlus = QueryPlus.wrap(baseQuery.withId(queryId));
        this.toolChest = this.warehouse.getToolChest(baseQuery);
    }

    public Access authorize(AuthenticationResult authenticationResult) {
        this.transition(State.INITIALIZED, State.AUTHORIZING);
        return this.doAuthorize(authenticationResult, AuthorizationUtils.authorizeAllResourceActions(authenticationResult, Iterables.transform(this.queryPlus.getQuery().getDataSource().getNames(), AuthorizationUtils.DATASOURCE_READ_RA_GENERATOR), this.authorizerMapper));
    }

    public Access authorize(HttpServletRequest req) {
        this.transition(State.INITIALIZED, State.AUTHORIZING);
        return this.doAuthorize(AuthorizationUtils.authenticationResultFromRequest(req), AuthorizationUtils.authorizeAllResourceActions(req, Iterables.transform(this.queryPlus.getQuery().getDataSource().getNames(), AuthorizationUtils.DATASOURCE_READ_RA_GENERATOR), this.authorizerMapper));
    }

    private Access doAuthorize(AuthenticationResult authenticationResult, Access authorizationResult) {
        if (!authorizationResult.isAllowed()) {
            this.transition(State.AUTHORIZING, State.UNAUTHORIZED);
        } else {
            this.transition(State.AUTHORIZING, State.AUTHORIZED);
        }
        this.authenticationResult = authenticationResult;
        QueryMetrics<?> queryMetrics = this.queryPlus.getQueryMetrics();
        if (queryMetrics != null) {
            queryMetrics.identity(authenticationResult.getIdentity());
        }
        return authorizationResult;
    }

    public QueryResponse execute() {
        this.transition(State.AUTHORIZED, State.EXECUTING);
        Map<String, Object> responseContext = DirectDruidClient.makeResponseContextForQuery(this.queryPlus.getQuery(), System.currentTimeMillis());
        Sequence res = this.queryPlus.run(this.texasRanger, responseContext);
        return new QueryResponse(res == null ? Sequences.empty() : res, responseContext);
    }

    public void emitLogsAndMetrics(@Nullable Throwable e, @Nullable String remoteAddress, long bytesWritten) {
        if (this.queryPlus == null) {
            return;
        }
        if (this.state == State.DONE) {
            log.warn("Tried to emit logs and metrics twice for query[%s]!", this.queryPlus.getQuery().getId());
        }
        this.state = State.DONE;
        Query query = this.queryPlus != null ? this.queryPlus.getQuery() : null;
        boolean success = e == null;
        try {
            long queryTimeNs = System.nanoTime() - this.startNs;
            QueryMetrics<?> queryMetrics = DruidMetrics.makeRequestMetrics(this.queryMetricsFactory, this.toolChest, this.queryPlus.getQuery(), Strings.nullToEmpty(remoteAddress));
            queryMetrics.success(success);
            queryMetrics.reportQueryTime(queryTimeNs);
            if (bytesWritten >= 0L) {
                queryMetrics.reportQueryBytes(bytesWritten);
            }
            queryMetrics.emit(this.emitter);
            LinkedHashMap<String, Object> statsMap = new LinkedHashMap<String, Object>();
            statsMap.put("query/time", TimeUnit.NANOSECONDS.toMillis(queryTimeNs));
            statsMap.put("query/bytes", bytesWritten);
            statsMap.put("success", success);
            if (this.authenticationResult != null) {
                statsMap.put("identity", this.authenticationResult.getIdentity());
            }
            if (e != null) {
                statsMap.put("exception", e.toString());
                if (e instanceof QueryInterruptedException) {
                    log.warn(e, "Exception while processing queryId [%s]", this.queryPlus.getQuery().getId());
                    statsMap.put("interrupted", true);
                    statsMap.put("reason", e.toString());
                }
            }
            this.requestLogger.log(new RequestLogLine(DateTimes.utc(this.startMs), Strings.nullToEmpty(remoteAddress), this.queryPlus.getQuery(), new QueryStats(statsMap)));
        }
        catch (Exception ex) {
            log.error(ex, "Unable to log query [%s]!", query);
        }
    }

    public Query getQuery() {
        return this.queryPlus.getQuery();
    }

    private void transition(State from, State to) {
        if (this.state != from) {
            throw new ISE("Cannot transition from[%s] to[%s].", new Object[]{from, to});
        }
        this.state = to;
    }

    public static class QueryResponse {
        private final Sequence results;
        private final Map<String, Object> responseContext;

        private QueryResponse(Sequence results, Map<String, Object> responseContext) {
            this.results = results;
            this.responseContext = responseContext;
        }

        public Sequence getResults() {
            return this.results;
        }

        public Map<String, Object> getResponseContext() {
            return this.responseContext;
        }
    }

    static enum State {
        NEW,
        INITIALIZED,
        AUTHORIZING,
        AUTHORIZED,
        EXECUTING,
        UNAUTHORIZED,
        DONE;

    }
}

