/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.virtual;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.io.druid.math.expr.Expr;
import org.apache.hive.druid.io.druid.math.expr.ExprEval;
import org.apache.hive.druid.io.druid.math.expr.Parser;
import org.apache.hive.druid.io.druid.query.dimension.DefaultDimensionSpec;
import org.apache.hive.druid.io.druid.query.expression.ExprUtils;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.io.druid.segment.BaseObjectColumnValueSelector;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.io.druid.segment.ColumnValueSelector;
import org.apache.hive.druid.io.druid.segment.ConstantColumnValueSelector;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;
import org.apache.hive.druid.io.druid.segment.DimensionSelectorUtils;
import org.apache.hive.druid.io.druid.segment.NilColumnValueSelector;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.data.IndexedInts;
import org.apache.hive.druid.io.druid.segment.virtual.BaseSingleValueDimensionSelector;
import org.apache.hive.druid.io.druid.segment.virtual.ExpressionColumnValueSelector;
import org.apache.hive.druid.io.druid.segment.virtual.SingleLongInputCachingExpressionColumnValueSelector;
import org.apache.hive.druid.io.druid.segment.virtual.SingleStringInputCachingExpressionColumnValueSelector;
import org.apache.hive.druid.io.druid.segment.virtual.SingleStringInputDimensionSelector;

public class ExpressionSelectors {
    private ExpressionSelectors() {
    }

    public static ColumnValueSelector makeColumnValueSelector(ColumnSelectorFactory columnSelectorFactory, Expr expression) {
        final ColumnValueSelector<ExprEval> baseSelector = ExpressionSelectors.makeExprEvalSelector(columnSelectorFactory, expression);
        return new ColumnValueSelector(){

            @Override
            public double getDouble() {
                return baseSelector.getDouble();
            }

            @Override
            public float getFloat() {
                return baseSelector.getFloat();
            }

            @Override
            public long getLong() {
                return baseSelector.getLong();
            }

            @Override
            @Nullable
            public Object getObject() {
                return ((ExprEval)baseSelector.getObject()).value();
            }

            @Override
            public Class classOfObject() {
                return Object.class;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("baseSelector", baseSelector);
            }
        };
    }

    public static ColumnValueSelector<ExprEval> makeExprEvalSelector(ColumnSelectorFactory columnSelectorFactory, Expr expression) {
        Expr.ObjectBinding bindings;
        List<String> columns = Parser.findRequiredBindings(expression);
        if (columns.size() == 1) {
            String column = Iterables.getOnlyElement(columns);
            ColumnCapabilities capabilities = columnSelectorFactory.getColumnCapabilities(column);
            if (column.equals("__time")) {
                return new SingleLongInputCachingExpressionColumnValueSelector(columnSelectorFactory.makeColumnValueSelector("__time"), expression);
            }
            if (capabilities != null && capabilities.getType() == ValueType.STRING && capabilities.isDictionaryEncoded()) {
                return new SingleStringInputCachingExpressionColumnValueSelector(columnSelectorFactory.makeDimensionSelector(new DefaultDimensionSpec(column, column, ValueType.STRING)), expression);
            }
        }
        if ((bindings = ExpressionSelectors.createBindings(expression, columnSelectorFactory)).equals(ExprUtils.nilBindings())) {
            ExprEval eval = expression.eval(bindings);
            return new ConstantColumnValueSelector<ExprEval>(eval.asLong(), (float)eval.asDouble(), eval.asDouble(), eval, ExprEval.class);
        }
        return new ExpressionColumnValueSelector(expression, bindings);
    }

    public static DimensionSelector makeDimensionSelector(ColumnSelectorFactory columnSelectorFactory, Expr expression, final ExtractionFn extractionFn) {
        String column;
        ColumnCapabilities capabilities;
        List<String> columns = Parser.findRequiredBindings(expression);
        if (columns.size() == 1 && (capabilities = columnSelectorFactory.getColumnCapabilities(column = Iterables.getOnlyElement(columns))) != null && capabilities.getType() == ValueType.STRING && capabilities.isDictionaryEncoded()) {
            return new SingleStringInputDimensionSelector(columnSelectorFactory.makeDimensionSelector(new DefaultDimensionSpec(column, column, ValueType.STRING)), expression);
        }
        final ColumnValueSelector<ExprEval> baseSelector = ExpressionSelectors.makeExprEvalSelector(columnSelectorFactory, expression);
        if (baseSelector instanceof ConstantColumnValueSelector) {
            return DimensionSelectorUtils.constantSelector(((ExprEval)baseSelector.getObject()).asString(), extractionFn);
        }
        if (extractionFn == null) {
            class DefaultExpressionDimensionSelector
            extends BaseSingleValueDimensionSelector {
                final /* synthetic */ ColumnValueSelector val$baseSelector;

                DefaultExpressionDimensionSelector(ColumnValueSelector columnValueSelector) {
                    this.val$baseSelector = columnValueSelector;
                }

                @Override
                protected String getValue() {
                    return Strings.emptyToNull(((ExprEval)this.val$baseSelector.getObject()).asString());
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    inspector.visit("baseSelector", this.val$baseSelector);
                }
            }
            return new DefaultExpressionDimensionSelector(baseSelector);
        }
        class ExtractionExpressionDimensionSelector
        extends BaseSingleValueDimensionSelector {
            ExtractionExpressionDimensionSelector() {
            }

            @Override
            protected String getValue() {
                return extractionFn.apply(Strings.emptyToNull(((ExprEval)baseSelector.getObject()).asString()));
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("baseSelector", baseSelector);
                inspector.visit("extractionFn", extractionFn);
            }
        }
        return new ExtractionExpressionDimensionSelector();
    }

    private static Expr.ObjectBinding createBindings(Expr expression, ColumnSelectorFactory columnSelectorFactory) {
        HashMap<String, Supplier<Object>> suppliers = Maps.newHashMap();
        for (String columnName : Parser.findRequiredBindings(expression)) {
            ValueType nativeType;
            ColumnCapabilities columnCapabilities = columnSelectorFactory.getColumnCapabilities(columnName);
            ValueType valueType = nativeType = columnCapabilities != null ? columnCapabilities.getType() : null;
            Supplier<Object> supplier = nativeType == ValueType.FLOAT ? columnSelectorFactory.makeColumnValueSelector(columnName)::getFloat : (nativeType == ValueType.LONG ? columnSelectorFactory.makeColumnValueSelector(columnName)::getLong : (nativeType == ValueType.DOUBLE ? columnSelectorFactory.makeColumnValueSelector(columnName)::getDouble : (nativeType == ValueType.STRING ? ExpressionSelectors.supplierFromDimensionSelector(columnSelectorFactory.makeDimensionSelector(new DefaultDimensionSpec(columnName, columnName))) : (nativeType == null ? ExpressionSelectors.supplierFromObjectSelector(columnSelectorFactory.makeColumnValueSelector(columnName)) : null))));
            if (supplier == null) continue;
            suppliers.put(columnName, supplier);
        }
        if (suppliers.isEmpty()) {
            return ExprUtils.nilBindings();
        }
        if (suppliers.size() == 1) {
            String column = (String)Iterables.getOnlyElement(suppliers.keySet());
            Supplier supplier = (Supplier)Iterables.getOnlyElement(suppliers.values());
            return identifierName -> {
                assert (column.equals(identifierName));
                return supplier.get();
            };
        }
        return Parser.withSuppliers(suppliers);
    }

    @Nonnull
    @VisibleForTesting
    static Supplier<Object> supplierFromDimensionSelector(DimensionSelector selector) {
        Preconditions.checkNotNull(selector, "selector");
        return () -> {
            IndexedInts row = selector.getRow();
            if (row.size() == 1) {
                return selector.lookupName(row.get(0));
            }
            return null;
        };
    }

    @Nullable
    static Supplier<Object> supplierFromObjectSelector(BaseObjectColumnValueSelector<?> selector) {
        Class<Object> clazz;
        block6: {
            block5: {
                if (selector instanceof NilColumnValueSelector) {
                    return null;
                }
                clazz = selector.classOfObject();
                if (Number.class.isAssignableFrom(clazz)) break block5;
                if (!String.class.isAssignableFrom(clazz)) break block6;
            }
            return selector::getObject;
        }
        if (clazz.isAssignableFrom(Number.class) || clazz.isAssignableFrom(String.class)) {
            return () -> {
                Object val = selector.getObject();
                if (val instanceof Number || val instanceof String) {
                    return val;
                }
                return null;
            };
        }
        return null;
    }
}

