/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.serde;

import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.io.druid.segment.column.DictionaryEncodedColumn;
import org.apache.hive.druid.io.druid.segment.column.SimpleDictionaryEncodedColumn;
import org.apache.hive.druid.io.druid.segment.data.CachingIndexed;
import org.apache.hive.druid.io.druid.segment.data.ColumnarInts;
import org.apache.hive.druid.io.druid.segment.data.ColumnarMultiInts;
import org.apache.hive.druid.io.druid.segment.data.GenericIndexed;

public class DictionaryEncodedColumnSupplier
implements Supplier<DictionaryEncodedColumn> {
    private final GenericIndexed<String> dictionary;
    private final Supplier<ColumnarInts> singleValuedColumn;
    private final Supplier<ColumnarMultiInts> multiValuedColumn;
    private final int lookupCacheSize;

    public DictionaryEncodedColumnSupplier(GenericIndexed<String> dictionary, Supplier<ColumnarInts> singleValuedColumn, Supplier<ColumnarMultiInts> multiValuedColumn, int lookupCacheSize) {
        this.dictionary = dictionary;
        this.singleValuedColumn = singleValuedColumn;
        this.multiValuedColumn = multiValuedColumn;
        this.lookupCacheSize = lookupCacheSize;
    }

    @Override
    public DictionaryEncodedColumn get() {
        return new SimpleDictionaryEncodedColumn(this.singleValuedColumn != null ? this.singleValuedColumn.get() : null, this.multiValuedColumn != null ? this.multiValuedColumn.get() : null, new CachingIndexed<String>(this.dictionary, this.lookupCacheSize));
    }
}

