/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.realtime.plumber;

import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.segment.realtime.plumber.RejectionPolicy;
import org.apache.hive.druid.io.druid.segment.realtime.plumber.RejectionPolicyFactory;
import org.joda.time.DateTime;
import org.joda.time.Period;

public class ServerTimeRejectionPolicyFactory
implements RejectionPolicyFactory {
    @Override
    public RejectionPolicy create(final Period windowPeriod) {
        final long windowMillis = windowPeriod.toStandardDuration().getMillis();
        return new RejectionPolicy(){

            @Override
            public DateTime getCurrMaxTime() {
                return DateTimes.nowUtc();
            }

            @Override
            public boolean accept(long timestamp) {
                long now = System.currentTimeMillis();
                boolean notTooOld = timestamp >= now - windowMillis;
                boolean notTooYoung = timestamp <= now + windowMillis;
                return notTooOld && notTooYoung;
            }

            public String toString() {
                return StringUtils.format("serverTime-%s", windowPeriod);
            }
        };
    }
}

