/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.realtime.appenderator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.SegmentIdentifier;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.SegmentWithState;

public class AppenderatorDriverMetadata {
    private final Map<String, List<SegmentWithState>> segments;
    private final Map<String, String> lastSegmentIds;
    private final Object callerMetadata;

    @JsonCreator
    public AppenderatorDriverMetadata(@JsonProperty(value="segments") Map<String, List<SegmentWithState>> segments, @JsonProperty(value="lastSegmentIds") Map<String, String> lastSegmentIds, @JsonProperty(value="callerMetadata") Object callerMetadata, @JsonProperty(value="activeSegments") Map<String, List<SegmentIdentifier>> activeSegments, @JsonProperty(value="publishPendingSegments") Map<String, List<SegmentIdentifier>> publishPendingSegments) {
        Preconditions.checkState(segments != null || activeSegments != null && publishPendingSegments != null, "Metadata should either have segments with state information or both active segments and publish pending segments information. segments [%s], activeSegments [%s], publishPendingSegments [%s]", new Object[]{segments, activeSegments, publishPendingSegments});
        if (segments == null) {
            HashMap<String, List<SegmentWithState>> newMetadata = Maps.newHashMap();
            HashSet activeSegmentsAlreadySeen = Sets.newHashSet();
            activeSegments.entrySet().forEach(sequenceSegments -> newMetadata.put((String)sequenceSegments.getKey(), ((List)sequenceSegments.getValue()).stream().map(segmentIdentifier -> {
                activeSegmentsAlreadySeen.add(segmentIdentifier.toString());
                return SegmentWithState.newSegment(segmentIdentifier);
            }).collect(Collectors.toList())));
            publishPendingSegments.entrySet().forEach(sequenceSegments -> newMetadata.computeIfAbsent((String)sequenceSegments.getKey(), k -> new ArrayList()).addAll(((List)sequenceSegments.getValue()).stream().filter(segmentIdentifier -> !activeSegmentsAlreadySeen.contains(segmentIdentifier.toString())).map(segmentIdentifier -> SegmentWithState.newSegment(segmentIdentifier, SegmentWithState.SegmentState.APPEND_FINISHED)).collect(Collectors.toList())));
            this.segments = newMetadata;
        } else {
            this.segments = segments;
        }
        this.lastSegmentIds = lastSegmentIds;
        this.callerMetadata = callerMetadata;
    }

    public AppenderatorDriverMetadata(Map<String, List<SegmentWithState>> segments, Map<String, String> lastSegmentIds, Object callerMetadata) {
        this(segments, lastSegmentIds, callerMetadata, null, null);
    }

    @JsonProperty
    public Map<String, List<SegmentWithState>> getSegments() {
        return this.segments;
    }

    @JsonProperty
    public Map<String, String> getLastSegmentIds() {
        return this.lastSegmentIds;
    }

    @JsonProperty
    public Object getCallerMetadata() {
        return this.callerMetadata;
    }

    public String toString() {
        return "AppenderatorDriverMetadata{segments=" + this.segments + ", lastSegmentIds=" + this.lastSegmentIds + ", callerMetadata=" + this.callerMetadata + '}';
    }
}

