/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.realtime.appenderator;

import java.io.Closeable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.druid.io.druid.data.input.Committer;
import org.apache.hive.druid.io.druid.data.input.InputRow;
import org.apache.hive.druid.io.druid.query.QuerySegmentWalker;
import org.apache.hive.druid.io.druid.segment.incremental.IndexSizeExceededException;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.SegmentIdentifier;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.SegmentNotWritableException;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.SegmentsAndMetadata;

public interface Appenderator
extends QuerySegmentWalker,
Closeable {
    public String getDataSource();

    public Object startJob();

    default public AppenderatorAddResult add(SegmentIdentifier identifier, InputRow row, Supplier<Committer> committerSupplier) throws IndexSizeExceededException, SegmentNotWritableException {
        return this.add(identifier, row, committerSupplier, true);
    }

    public AppenderatorAddResult add(SegmentIdentifier var1, InputRow var2, @Nullable Supplier<Committer> var3, boolean var4) throws IndexSizeExceededException, SegmentNotWritableException;

    public List<SegmentIdentifier> getSegments();

    public int getRowCount(SegmentIdentifier var1);

    public int getTotalRowCount();

    public void clear() throws InterruptedException;

    public ListenableFuture<?> drop(SegmentIdentifier var1);

    public ListenableFuture<Object> persist(Collection<SegmentIdentifier> var1, @Nullable Committer var2);

    default public ListenableFuture<Object> persistAll(@Nullable Committer committer) {
        return this.persist(this.getSegments(), committer);
    }

    public ListenableFuture<SegmentsAndMetadata> push(Collection<SegmentIdentifier> var1, @Nullable Committer var2);

    @Override
    public void close();

    public void closeNow();

    public static class AppenderatorAddResult {
        private final SegmentIdentifier segmentIdentifier;
        private final int numRowsInSegment;
        private final boolean isPersistRequired;

        AppenderatorAddResult(SegmentIdentifier identifier, int numRowsInSegment, boolean isPersistRequired) {
            this.segmentIdentifier = identifier;
            this.numRowsInSegment = numRowsInSegment;
            this.isPersistRequired = isPersistRequired;
        }

        SegmentIdentifier getSegmentIdentifier() {
            return this.segmentIdentifier;
        }

        int getNumRowsInSegment() {
            return this.numRowsInSegment;
        }

        boolean isPersistRequired() {
            return this.isPersistRequired;
        }
    }
}

