/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.filter;

import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.NoSuchElementException;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.io.druid.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.io.druid.query.BitmapResultFactory;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.io.druid.query.filter.BitmapIndexSelector;
import org.apache.hive.druid.io.druid.query.filter.Filter;
import org.apache.hive.druid.io.druid.query.filter.LikeDimFilter;
import org.apache.hive.druid.io.druid.query.filter.ValueMatcher;
import org.apache.hive.druid.io.druid.segment.ColumnSelector;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.io.druid.segment.column.BitmapIndex;
import org.apache.hive.druid.io.druid.segment.data.Indexed;
import org.apache.hive.druid.io.druid.segment.filter.Filters;

public class LikeFilter
implements Filter {
    private final String dimension;
    private final ExtractionFn extractionFn;
    private final LikeDimFilter.LikeMatcher likeMatcher;

    public LikeFilter(String dimension, ExtractionFn extractionFn, LikeDimFilter.LikeMatcher likeMatcher) {
        this.dimension = dimension;
        this.extractionFn = extractionFn;
        this.likeMatcher = likeMatcher;
    }

    @Override
    public <T> T getBitmapResult(BitmapIndexSelector selector, BitmapResultFactory<T> bitmapResultFactory) {
        return bitmapResultFactory.unionDimensionValueBitmaps(this.getBitmapIterable(selector));
    }

    @Override
    public double estimateSelectivity(BitmapIndexSelector selector) {
        return Filters.estimateSelectivity(this.getBitmapIterable(selector).iterator(), selector.getNumRows());
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        return Filters.makeValueMatcher(factory, this.dimension, this.likeMatcher.predicateFactory(this.extractionFn));
    }

    @Override
    public boolean supportsBitmapIndex(BitmapIndexSelector selector) {
        return selector.getBitmapIndex(this.dimension) != null;
    }

    @Override
    public boolean supportsSelectivityEstimation(ColumnSelector columnSelector, BitmapIndexSelector indexSelector) {
        return Filters.supportsSelectivityEstimation(this, this.dimension, columnSelector, indexSelector);
    }

    private Iterable<ImmutableBitmap> getBitmapIterable(BitmapIndexSelector selector) {
        if (this.isSimpleEquals()) {
            return ImmutableList.of(selector.getBitmapIndex(this.dimension, this.likeMatcher.getPrefix()));
        }
        if (this.isSimplePrefix()) {
            BitmapIndex bitmapIndex = selector.getBitmapIndex(this.dimension);
            if (bitmapIndex == null) {
                return ImmutableList.of(this.likeMatcher.matches(null) ? Filters.allTrue(selector) : Filters.allFalse(selector));
            }
            Indexed<String> dimValues = selector.getDimensionValues(this.dimension);
            return Filters.bitmapsFromIndexes(this.getDimValueIndexIterableForPrefixMatch(bitmapIndex, dimValues), bitmapIndex);
        }
        return Filters.matchPredicateNoUnion(this.dimension, selector, this.likeMatcher.predicateFactory(this.extractionFn).makeStringPredicate());
    }

    private boolean isSimpleEquals() {
        return this.extractionFn == null && this.likeMatcher.getSuffixMatch() == LikeDimFilter.LikeMatcher.SuffixMatch.MATCH_EMPTY;
    }

    private boolean isSimplePrefix() {
        return this.extractionFn == null && !this.likeMatcher.getPrefix().isEmpty();
    }

    private IntIterable getDimValueIndexIterableForPrefixMatch(BitmapIndex bitmapIndex, final Indexed<String> dimValues) {
        String lower = Strings.nullToEmpty(this.likeMatcher.getPrefix());
        String upper = Strings.nullToEmpty(this.likeMatcher.getPrefix()) + '\uffff';
        int lowerFound = bitmapIndex.getIndex(lower);
        final int startIndex = lowerFound >= 0 ? lowerFound : -(lowerFound + 1);
        int upperFound = bitmapIndex.getIndex(upper);
        final int endIndex = upperFound >= 0 ? upperFound + 1 : -(upperFound + 1);
        return new IntIterable(){

            @Override
            public IntIterator iterator() {
                return new IntIterator(){
                    int currIndex;
                    int found;
                    {
                        this.currIndex = startIndex;
                        this.found = -1;
                        this.found = this.findNext();
                    }

                    private int findNext() {
                        while (this.currIndex < endIndex && !LikeFilter.this.likeMatcher.matchesSuffixOnly(dimValues, this.currIndex)) {
                            ++this.currIndex;
                        }
                        if (this.currIndex < endIndex) {
                            return this.currIndex++;
                        }
                        return -1;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.found != -1;
                    }

                    @Override
                    public int nextInt() {
                        int cur = this.found;
                        if (cur == -1) {
                            throw new NoSuchElementException();
                        }
                        this.found = this.findNext();
                        return cur;
                    }
                };
            }
        };
    }
}

