/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.filter;

import java.util.Set;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.io.druid.math.expr.Evals;
import org.apache.hive.druid.io.druid.math.expr.Expr;
import org.apache.hive.druid.io.druid.math.expr.ExprEval;
import org.apache.hive.druid.io.druid.math.expr.Parser;
import org.apache.hive.druid.io.druid.query.BitmapResultFactory;
import org.apache.hive.druid.io.druid.query.expression.ExprUtils;
import org.apache.hive.druid.io.druid.query.filter.BitmapIndexSelector;
import org.apache.hive.druid.io.druid.query.filter.Filter;
import org.apache.hive.druid.io.druid.query.filter.ValueMatcher;
import org.apache.hive.druid.io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.io.druid.segment.ColumnSelector;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.io.druid.segment.ColumnValueSelector;
import org.apache.hive.druid.io.druid.segment.filter.Filters;
import org.apache.hive.druid.io.druid.segment.virtual.ExpressionSelectors;

public class ExpressionFilter
implements Filter {
    private final Expr expr;
    private final Set<String> requiredBindings;

    public ExpressionFilter(Expr expr) {
        this.expr = expr;
        this.requiredBindings = ImmutableSet.copyOf(Parser.findRequiredBindings(expr));
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        final ColumnValueSelector<ExprEval> selector = ExpressionSelectors.makeExprEvalSelector(factory, this.expr);
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                return Evals.asBoolean(selector.getLong());
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
            }
        };
    }

    @Override
    public boolean supportsBitmapIndex(BitmapIndexSelector selector) {
        if (this.requiredBindings.isEmpty()) {
            return true;
        }
        if (this.requiredBindings.size() == 1) {
            String column = Iterables.getOnlyElement(this.requiredBindings);
            return selector.getBitmapIndex(column) != null && !selector.hasMultipleValues(column);
        }
        return false;
    }

    @Override
    public <T> T getBitmapResult(BitmapIndexSelector selector, BitmapResultFactory<T> bitmapResultFactory) {
        if (this.requiredBindings.isEmpty()) {
            if (this.expr.eval(ExprUtils.nilBindings()).asBoolean()) {
                return bitmapResultFactory.wrapAllTrue(Filters.allTrue(selector));
            }
            return bitmapResultFactory.wrapAllFalse(Filters.allFalse(selector));
        }
        String column = Iterables.getOnlyElement(this.requiredBindings);
        return Filters.matchPredicate(column, selector, bitmapResultFactory, value -> this.expr.eval(identifierName -> {
            assert (column.equals(identifierName));
            return value;
        }).asBoolean());
    }

    @Override
    public boolean supportsSelectivityEstimation(ColumnSelector columnSelector, BitmapIndexSelector indexSelector) {
        return false;
    }

    @Override
    public double estimateSelectivity(BitmapIndexSelector indexSelector) {
        throw new UnsupportedOperationException();
    }
}

