/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import org.apache.hive.druid.io.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.hive.druid.io.druid.segment.data.ColumnarLongsSerializer;
import org.apache.hive.druid.io.druid.segment.data.CompressionFactory;
import org.apache.hive.druid.io.druid.segment.data.CompressionStrategy;
import org.apache.hive.druid.io.druid.segment.serde.MetaSerdeHelper;
import org.apache.hive.druid.io.druid.segment.writeout.SegmentWriteOutMedium;
import org.apache.hive.druid.io.druid.segment.writeout.WriteOutBytes;

public class EntireLayoutColumnarLongsSerializer
implements ColumnarLongsSerializer {
    private static final MetaSerdeHelper<EntireLayoutColumnarLongsSerializer> metaSerdeHelper = MetaSerdeHelper.firstWriteByte(x -> 2).writeInt(x -> x.numInserted).writeInt(x -> 0).writeSomething(CompressionFactory.longEncodingWriter(x -> x.writer, x -> CompressionStrategy.NONE));
    private final CompressionFactory.LongEncodingWriter writer;
    private final SegmentWriteOutMedium segmentWriteOutMedium;
    private WriteOutBytes valuesOut;
    private int numInserted = 0;

    EntireLayoutColumnarLongsSerializer(SegmentWriteOutMedium segmentWriteOutMedium, CompressionFactory.LongEncodingWriter writer) {
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.writer = writer;
    }

    @Override
    public void open() throws IOException {
        this.valuesOut = this.segmentWriteOutMedium.makeWriteOutBytes();
        this.writer.setOutputStream(this.valuesOut);
    }

    @Override
    public int size() {
        return this.numInserted;
    }

    @Override
    public void add(long value) throws IOException {
        this.writer.write(value);
        ++this.numInserted;
    }

    @Override
    public long getSerializedSize() throws IOException {
        this.writer.flush();
        return (long)metaSerdeHelper.size(this) + this.valuesOut.size();
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        this.writer.flush();
        metaSerdeHelper.writeTo(channel, this);
        this.valuesOut.writeTo(channel);
    }
}

