/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Iterator;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.io.Closeables;
import org.apache.hive.druid.io.druid.collections.ResourceHolder;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.java.util.common.guava.CloseQuietly;
import org.apache.hive.druid.io.druid.java.util.common.io.Closer;
import org.apache.hive.druid.io.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.hive.druid.io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.io.druid.segment.data.ColumnarInts;
import org.apache.hive.druid.io.druid.segment.data.CompressionStrategy;
import org.apache.hive.druid.io.druid.segment.data.DecompressingByteBufferObjectStrategy;
import org.apache.hive.druid.io.druid.segment.data.GenericIndexed;
import org.apache.hive.druid.io.druid.segment.data.Indexed;
import org.apache.hive.druid.io.druid.segment.data.WritableSupplier;
import org.apache.hive.druid.io.druid.segment.serde.MetaSerdeHelper;

public class CompressedColumnarIntsSupplier
implements WritableSupplier<ColumnarInts> {
    public static final byte VERSION = 2;
    public static final int MAX_INTS_IN_BUFFER = 16384;
    private static MetaSerdeHelper<CompressedColumnarIntsSupplier> metaSerdeHelper = MetaSerdeHelper.firstWriteByte(x -> 2).writeInt(x -> x.totalSize).writeInt(x -> x.sizePer).writeByte(x -> x.compression.getId());
    private final int totalSize;
    private final int sizePer;
    private final GenericIndexed<ResourceHolder<ByteBuffer>> baseIntBuffers;
    private final CompressionStrategy compression;

    private CompressedColumnarIntsSupplier(int totalSize, int sizePer, GenericIndexed<ResourceHolder<ByteBuffer>> baseIntBuffers, CompressionStrategy compression) {
        this.totalSize = totalSize;
        this.sizePer = sizePer;
        this.baseIntBuffers = baseIntBuffers;
        this.compression = compression;
    }

    @Override
    public ColumnarInts get() {
        boolean powerOf2;
        final int div = Integer.numberOfTrailingZeros(this.sizePer);
        final int rem = this.sizePer - 1;
        boolean bl = powerOf2 = this.sizePer == 1 << div;
        if (powerOf2) {
            return new CompressedColumnarInts(){

                @Override
                public int get(int index) {
                    int bufferNum = index >> div;
                    if (bufferNum != this.currIndex) {
                        this.loadBuffer(bufferNum);
                    }
                    int bufferIndex = index & rem;
                    return this.buffer.get(this.buffer.position() + bufferIndex);
                }
            };
        }
        return new CompressedColumnarInts();
    }

    @Override
    public long getSerializedSize() throws IOException {
        return (long)metaSerdeHelper.size(this) + this.baseIntBuffers.getSerializedSize();
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        metaSerdeHelper.writeTo(channel, this);
        this.baseIntBuffers.writeTo(channel, smoosher);
    }

    @VisibleForTesting
    GenericIndexed<?> getBaseIntBuffers() {
        return this.baseIntBuffers;
    }

    public static CompressedColumnarIntsSupplier fromByteBuffer(ByteBuffer buffer, ByteOrder order) {
        byte versionFromBuffer = buffer.get();
        if (versionFromBuffer == 2) {
            int totalSize = buffer.getInt();
            int sizePer = buffer.getInt();
            CompressionStrategy compression = CompressionStrategy.forId(buffer.get());
            return new CompressedColumnarIntsSupplier(totalSize, sizePer, GenericIndexed.read(buffer, new DecompressingByteBufferObjectStrategy(order, compression)), compression);
        }
        throw new IAE("Unknown version[%s]", versionFromBuffer);
    }

    @VisibleForTesting
    static CompressedColumnarIntsSupplier fromIntBuffer(final IntBuffer buffer, final int chunkFactor, final ByteOrder byteOrder, final CompressionStrategy compression, final Closer closer) {
        Preconditions.checkArgument(chunkFactor <= 16384, "Chunks must be <= 64k bytes. chunkFactor was[%s]", new Object[]{chunkFactor});
        return new CompressedColumnarIntsSupplier(buffer.remaining(), chunkFactor, GenericIndexed.ofCompressedByteBuffers(new Iterable<ByteBuffer>(){

            @Override
            public Iterator<ByteBuffer> iterator() {
                return new Iterator<ByteBuffer>(){
                    final IntBuffer myBuffer;
                    final ByteBuffer retVal;
                    final IntBuffer retValAsIntBuffer;
                    {
                        this.myBuffer = buffer.asReadOnlyBuffer();
                        this.retVal = compression.getCompressor().allocateInBuffer(chunkFactor * 4, closer).order(byteOrder);
                        this.retValAsIntBuffer = this.retVal.asIntBuffer();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.myBuffer.hasRemaining();
                    }

                    @Override
                    public ByteBuffer next() {
                        int initialLimit = this.myBuffer.limit();
                        if (chunkFactor < this.myBuffer.remaining()) {
                            this.myBuffer.limit(this.myBuffer.position() + chunkFactor);
                        }
                        this.retValAsIntBuffer.clear();
                        this.retValAsIntBuffer.put(this.myBuffer);
                        this.myBuffer.limit(initialLimit);
                        this.retVal.clear().limit(this.retValAsIntBuffer.position() * 4);
                        return this.retVal;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }, compression, chunkFactor * 4, byteOrder, closer), compression);
    }

    @VisibleForTesting
    public static CompressedColumnarIntsSupplier fromList(final IntArrayList list, final int chunkFactor, final ByteOrder byteOrder, final CompressionStrategy compression, final Closer closer) {
        Preconditions.checkArgument(chunkFactor <= 16384, "Chunks must be <= 64k bytes. chunkFactor was[%s]", new Object[]{chunkFactor});
        return new CompressedColumnarIntsSupplier(list.size(), chunkFactor, GenericIndexed.ofCompressedByteBuffers(new Iterable<ByteBuffer>(){

            @Override
            public Iterator<ByteBuffer> iterator() {
                return new Iterator<ByteBuffer>(){
                    private final ByteBuffer retVal;
                    int position;
                    {
                        this.retVal = compression.getCompressor().allocateInBuffer(chunkFactor * 4, closer).order(byteOrder);
                        this.position = 0;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.position < list.size();
                    }

                    @Override
                    public ByteBuffer next() {
                        int blockSize = Math.min(list.size() - this.position, chunkFactor);
                        this.retVal.clear();
                        int limit = this.position + blockSize;
                        while (this.position < limit) {
                            this.retVal.putInt(list.getInt(this.position));
                            ++this.position;
                        }
                        this.retVal.flip();
                        return this.retVal;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }, compression, chunkFactor * 4, byteOrder, closer), compression);
    }

    private class CompressedColumnarInts
    implements ColumnarInts {
        final Indexed<ResourceHolder<ByteBuffer>> singleThreadedIntBuffers;
        int currIndex;
        ResourceHolder<ByteBuffer> holder;
        IntBuffer buffer;

        private CompressedColumnarInts() {
            this.singleThreadedIntBuffers = CompressedColumnarIntsSupplier.this.baseIntBuffers.singleThreaded();
            this.currIndex = -1;
        }

        @Override
        public int size() {
            return CompressedColumnarIntsSupplier.this.totalSize;
        }

        @Override
        public int get(int index) {
            int bufferNum = index / CompressedColumnarIntsSupplier.this.sizePer;
            int bufferIndex = index % CompressedColumnarIntsSupplier.this.sizePer;
            if (bufferNum != this.currIndex) {
                this.loadBuffer(bufferNum);
            }
            return this.buffer.get(this.buffer.position() + bufferIndex);
        }

        protected void loadBuffer(int bufferNum) {
            CloseQuietly.close(this.holder);
            this.holder = this.singleThreadedIntBuffers.get(bufferNum);
            this.buffer = this.holder.get().asIntBuffer();
            this.currIndex = bufferNum;
        }

        public String toString() {
            return "CompressedIntsIndexedSupplier_Anonymous{currIndex=" + this.currIndex + ", sizePer=" + CompressedColumnarIntsSupplier.this.sizePer + ", numChunks=" + this.singleThreadedIntBuffers.size() + ", totalSize=" + CompressedColumnarIntsSupplier.this.totalSize + '}';
        }

        @Override
        public void close() throws IOException {
            Closeables.close(this.holder, false);
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            inspector.visit("singleThreadedIntBuffers", this.singleThreadedIntBuffers);
        }
    }
}

