/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.column;

import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.io.druid.segment.ColumnValueSelector;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;
import org.apache.hive.druid.io.druid.segment.DoubleWrappingDimensionSelector;
import org.apache.hive.druid.io.druid.segment.FloatWrappingDimensionSelector;
import org.apache.hive.druid.io.druid.segment.LongWrappingDimensionSelector;

public enum ValueType {
    FLOAT{

        @Override
        public DimensionSelector makeNumericWrappingDimensionSelector(ColumnValueSelector numericColumnValueSelector, ExtractionFn extractionFn) {
            return new FloatWrappingDimensionSelector(numericColumnValueSelector, extractionFn);
        }
    }
    ,
    DOUBLE{

        @Override
        public DimensionSelector makeNumericWrappingDimensionSelector(ColumnValueSelector numericColumnValueSelector, ExtractionFn extractionFn) {
            return new DoubleWrappingDimensionSelector(numericColumnValueSelector, extractionFn);
        }
    }
    ,
    LONG{

        @Override
        public DimensionSelector makeNumericWrappingDimensionSelector(ColumnValueSelector numericColumnValueSelector, ExtractionFn extractionFn) {
            return new LongWrappingDimensionSelector(numericColumnValueSelector, extractionFn);
        }
    }
    ,
    STRING,
    COMPLEX;


    public DimensionSelector makeNumericWrappingDimensionSelector(ColumnValueSelector numericColumnValueSelector, ExtractionFn extractionFn) {
        throw new UnsupportedOperationException("Not a numeric value type: " + this.name());
    }

    public boolean isNumeric() {
        return ValueType.isNumeric(this);
    }

    @JsonCreator
    public static ValueType fromString(String name) {
        if (name == null) {
            return null;
        }
        return ValueType.valueOf(StringUtils.toUpperCase(name));
    }

    public static boolean isNumeric(ValueType type) {
        return type == LONG || type == FLOAT || type == DOUBLE;
    }
}

