/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.io.IOException;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.hive.druid.com.google.common.base.Splitter;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.collections.bitmap.BitmapFactory;
import org.apache.hive.druid.io.druid.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.io.druid.collections.bitmap.MutableBitmap;
import org.apache.hive.druid.io.druid.collections.spatial.ImmutableRTree;
import org.apache.hive.druid.io.druid.collections.spatial.RTree;
import org.apache.hive.druid.io.druid.collections.spatial.split.LinearGutmanSplitStrategy;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.segment.DimensionMergerV9;
import org.apache.hive.druid.io.druid.segment.IndexIO;
import org.apache.hive.druid.io.druid.segment.IndexMerger;
import org.apache.hive.druid.io.druid.segment.IndexSpec;
import org.apache.hive.druid.io.druid.segment.IndexableAdapter;
import org.apache.hive.druid.io.druid.segment.IntIteratorUtils;
import org.apache.hive.druid.io.druid.segment.ProgressIndicator;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.io.druid.segment.column.ColumnDescriptor;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.data.ArrayIndexed;
import org.apache.hive.druid.io.druid.segment.data.BitmapSerdeFactory;
import org.apache.hive.druid.io.druid.segment.data.BitmapValues;
import org.apache.hive.druid.io.druid.segment.data.ByteBufferWriter;
import org.apache.hive.druid.io.druid.segment.data.ColumnarIntsSerializer;
import org.apache.hive.druid.io.druid.segment.data.CompressedVSizeColumnarIntsSerializer;
import org.apache.hive.druid.io.druid.segment.data.CompressionStrategy;
import org.apache.hive.druid.io.druid.segment.data.GenericIndexed;
import org.apache.hive.druid.io.druid.segment.data.GenericIndexedWriter;
import org.apache.hive.druid.io.druid.segment.data.ImmutableRTreeObjectStrategy;
import org.apache.hive.druid.io.druid.segment.data.Indexed;
import org.apache.hive.druid.io.druid.segment.data.V3CompressedVSizeColumnarMultiIntsSerializer;
import org.apache.hive.druid.io.druid.segment.data.VSizeColumnarIntsSerializer;
import org.apache.hive.druid.io.druid.segment.data.VSizeColumnarMultiIntsSerializer;
import org.apache.hive.druid.io.druid.segment.serde.DictionaryEncodedColumnPartSerde;
import org.apache.hive.druid.io.druid.segment.writeout.SegmentWriteOutMedium;

public class StringDimensionMergerV9
implements DimensionMergerV9<int[]> {
    private static final Logger log = new Logger(StringDimensionMergerV9.class);
    private static final Indexed<String> EMPTY_STR_DIM_VAL = new ArrayIndexed<String>(new String[]{""}, String.class);
    private static final int[] EMPTY_STR_DIM_ARRAY = new int[]{0};
    private static final Splitter SPLITTER = Splitter.on(",");
    private ColumnarIntsSerializer encodedValueWriter;
    private String dimensionName;
    private GenericIndexedWriter<String> dictionaryWriter;
    private String firstDictionaryValue;
    private int dictionarySize;
    private GenericIndexedWriter<ImmutableBitmap> bitmapWriter;
    private ByteBufferWriter<ImmutableRTree> spatialWriter;
    private ArrayList<IntBuffer> dimConversions;
    private int cardinality = 0;
    private boolean convertMissingValues = false;
    private boolean hasNull = false;
    private MutableBitmap nullRowsBitmap;
    private final SegmentWriteOutMedium segmentWriteOutMedium;
    private int rowCount = 0;
    private ColumnCapabilities capabilities;
    private List<IndexableAdapter> adapters;
    private ProgressIndicator progress;
    private final IndexSpec indexSpec;
    private IndexMerger.DictionaryMergeIterator dictionaryMergeIterator;

    public StringDimensionMergerV9(String dimensionName, IndexSpec indexSpec, SegmentWriteOutMedium segmentWriteOutMedium, ColumnCapabilities capabilities, ProgressIndicator progress) {
        this.dimensionName = dimensionName;
        this.indexSpec = indexSpec;
        this.capabilities = capabilities;
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.progress = progress;
        this.nullRowsBitmap = indexSpec.getBitmapSerdeFactory().getBitmapFactory().makeEmptyMutableBitmap();
    }

    @Override
    public void writeMergedValueMetadata(List<IndexableAdapter> adapters) throws IOException {
        boolean dimHasValues = false;
        boolean dimAbsentFromSomeIndex = false;
        long dimStartTime = System.currentTimeMillis();
        this.adapters = adapters;
        this.dimConversions = Lists.newArrayListWithCapacity(adapters.size());
        for (int i = 0; i < adapters.size(); ++i) {
            this.dimConversions.add(null);
        }
        int numMergeIndex = 0;
        Indexed<Object> dimValueLookup = null;
        Indexed[] dimValueLookups = new Indexed[adapters.size() + 1];
        for (int i = 0; i < adapters.size(); ++i) {
            Indexed<Comparable> dimValues = adapters.get(i).getDimValueLookup(this.dimensionName);
            if (!this.isNullColumn(dimValues)) {
                dimHasValues = true;
                this.hasNull |= dimValues.indexOf(null) >= 0;
                dimValueLookup = dimValues;
                dimValueLookups[i] = dimValueLookup;
                ++numMergeIndex;
                continue;
            }
            dimAbsentFromSomeIndex = true;
        }
        boolean bl = this.convertMissingValues = dimHasValues && dimAbsentFromSomeIndex;
        if (this.convertMissingValues && !this.hasNull) {
            this.hasNull = true;
            dimValueLookup = EMPTY_STR_DIM_VAL;
            dimValueLookups[adapters.size()] = dimValueLookup;
            ++numMergeIndex;
        }
        String dictFilename = StringUtils.format("%s.dim_values", this.dimensionName);
        this.dictionaryWriter = new GenericIndexedWriter<String>(this.segmentWriteOutMedium, dictFilename, GenericIndexed.STRING_STRATEGY);
        this.firstDictionaryValue = null;
        this.dictionarySize = 0;
        this.dictionaryWriter.open();
        this.cardinality = 0;
        if (numMergeIndex > 1) {
            this.dictionaryMergeIterator = new IndexMerger.DictionaryMergeIterator(dimValueLookups, true);
            this.writeDictionary(() -> this.dictionaryMergeIterator);
            for (int i = 0; i < adapters.size(); ++i) {
                if (dimValueLookups[i] == null || !this.dictionaryMergeIterator.needConversion(i)) continue;
                this.dimConversions.set(i, this.dictionaryMergeIterator.conversions[i]);
            }
            this.cardinality = this.dictionaryMergeIterator.counter;
        } else if (numMergeIndex == 1) {
            this.writeDictionary(dimValueLookup);
            this.cardinality = dimValueLookup.size();
        }
        log.info("Completed dim[%s] conversions with cardinality[%,d] in %,d millis.", this.dimensionName, this.cardinality, System.currentTimeMillis() - dimStartTime);
        this.setupEncodedValueWriter();
    }

    private void writeDictionary(Iterable<String> dictionaryValues) throws IOException {
        for (String value : dictionaryValues) {
            this.dictionaryWriter.write(value);
            value = Strings.emptyToNull(value);
            if (this.dictionarySize == 0) {
                this.firstDictionaryValue = value;
            }
            ++this.dictionarySize;
        }
    }

    protected void setupEncodedValueWriter() throws IOException {
        CompressionStrategy compressionStrategy = this.indexSpec.getDimensionCompression();
        String filenameBase = StringUtils.format("%s.forward_dim", this.dimensionName);
        this.encodedValueWriter = this.capabilities.hasMultipleValues() ? (compressionStrategy != CompressionStrategy.UNCOMPRESSED ? V3CompressedVSizeColumnarMultiIntsSerializer.create(this.segmentWriteOutMedium, filenameBase, this.cardinality, compressionStrategy) : new VSizeColumnarMultiIntsSerializer(this.segmentWriteOutMedium, this.cardinality)) : (compressionStrategy != CompressionStrategy.UNCOMPRESSED ? CompressedVSizeColumnarIntsSerializer.create(this.segmentWriteOutMedium, filenameBase, this.cardinality, compressionStrategy) : new VSizeColumnarIntsSerializer(this.segmentWriteOutMedium, this.cardinality));
        this.encodedValueWriter.open();
    }

    @Override
    public int[] convertSegmentRowValuesToMergedRowValues(int[] segmentRow, int segmentIndexNumber) {
        int[] dimVals = segmentRow;
        if (dimVals == null) {
            return (int[])(this.convertMissingValues ? EMPTY_STR_DIM_ARRAY : null);
        }
        int[] newDimVals = new int[dimVals.length];
        IntBuffer converter = this.dimConversions.get(segmentIndexNumber);
        for (int i = 0; i < dimVals.length; ++i) {
            newDimVals[i] = converter != null ? converter.get(dimVals[i]) : dimVals[i];
        }
        return newDimVals;
    }

    @Override
    public void processMergedRow(int[] rowValues) throws IOException {
        int[] vals = rowValues;
        if (vals == null || vals.length == 0) {
            this.nullRowsBitmap.add(this.rowCount);
        } else if (this.hasNull && vals.length == 1 && vals[0] == 0) {
            this.nullRowsBitmap.add(this.rowCount);
        }
        this.processMergedRowHelper(vals);
        ++this.rowCount;
    }

    protected void processMergedRowHelper(int[] vals) throws IOException {
        this.encodedValueWriter.add(vals);
    }

    @Override
    public void writeIndexes(List<IntBuffer> segmentRowNumConversions) throws IOException {
        long dimStartTime = System.currentTimeMillis();
        BitmapSerdeFactory bitmapSerdeFactory = this.indexSpec.getBitmapSerdeFactory();
        String bmpFilename = StringUtils.format("%s.inverted", this.dimensionName);
        this.bitmapWriter = new GenericIndexedWriter<ImmutableBitmap>(this.segmentWriteOutMedium, bmpFilename, this.indexSpec.getBitmapSerdeFactory().getObjectStrategy());
        this.bitmapWriter.open();
        this.bitmapWriter.setObjectsNotSorted();
        BitmapFactory bitmapFactory = bitmapSerdeFactory.getBitmapFactory();
        RTree tree = null;
        boolean hasSpatial = this.capabilities.hasSpatialIndexes();
        if (hasSpatial) {
            this.spatialWriter = new ByteBufferWriter<ImmutableRTree>(this.segmentWriteOutMedium, new ImmutableRTreeObjectStrategy(bitmapFactory));
            this.spatialWriter.open();
            tree = new RTree(2, new LinearGutmanSplitStrategy(0, 50, bitmapFactory), bitmapFactory);
        }
        IndexSeeker[] dictIdSeeker = this.toIndexSeekers(this.adapters, this.dimConversions, this.dimensionName);
        for (int dictId = 0; dictId < this.dictionarySize; ++dictId) {
            this.progress.progress();
            this.mergeBitmaps(segmentRowNumConversions, bitmapFactory, tree, hasSpatial, dictIdSeeker, dictId);
        }
        if (hasSpatial) {
            this.spatialWriter.write(ImmutableRTree.newImmutableFromMutable(tree));
        }
        log.info("Completed dim[%s] inverted with cardinality[%,d] in %,d millis.", this.dimensionName, this.dictionarySize, System.currentTimeMillis() - dimStartTime);
        if (this.dictionaryMergeIterator != null) {
            this.dictionaryMergeIterator.close();
        }
    }

    void mergeBitmaps(List<IntBuffer> segmentRowNumConversions, BitmapFactory bmpFactory, RTree tree, boolean hasSpatial, IndexSeeker[] dictIdSeeker, int dictId) throws IOException {
        String dimVal;
        ArrayList<ConvertingBitmapValues> convertedInvertedIndexesToMerge = Lists.newArrayListWithCapacity(this.adapters.size());
        for (int j = 0; j < this.adapters.size(); ++j) {
            int seekedDictId = dictIdSeeker[j].seek(dictId);
            if (seekedDictId == -1) continue;
            convertedInvertedIndexesToMerge.add(new ConvertingBitmapValues(this.adapters.get(j).getBitmapValues(this.dimensionName, seekedDictId), segmentRowNumConversions.get(j)));
        }
        MutableBitmap mergedIndexes = bmpFactory.makeEmptyMutableBitmap();
        ArrayList<IntIterator> convertedInvertedIndexesIterators = new ArrayList<IntIterator>(convertedInvertedIndexesToMerge.size());
        for (ConvertingBitmapValues convertedInvertedIndexes : convertedInvertedIndexesToMerge) {
            convertedInvertedIndexesIterators.add(convertedInvertedIndexes.iterator());
        }
        int prevRow = -1;
        IntIterator mergeIt = IntIteratorUtils.mergeAscending(convertedInvertedIndexesIterators);
        while (mergeIt.hasNext()) {
            int row = mergeIt.nextInt();
            if (row != prevRow && row != -1) {
                mergedIndexes.add(row);
            }
            prevRow = row;
        }
        if (dictId == 0 && this.firstDictionaryValue == null) {
            mergedIndexes.or(this.nullRowsBitmap);
        }
        this.bitmapWriter.write(bmpFactory.makeImmutableBitmap(mergedIndexes));
        if (hasSpatial && (dimVal = this.dictionaryWriter.get(dictId)) != null) {
            ArrayList<String> stringCoords = Lists.newArrayList(SPLITTER.split(dimVal));
            float[] coords = new float[stringCoords.size()];
            for (int j = 0; j < coords.length; ++j) {
                coords[j] = Float.valueOf((String)stringCoords.get(j)).floatValue();
            }
            tree.insert(coords, mergedIndexes);
        }
    }

    @Override
    public boolean canSkip() {
        return this.cardinality == 0;
    }

    @Override
    public ColumnDescriptor makeColumnDescriptor() {
        boolean hasMultiValue = this.capabilities.hasMultipleValues();
        CompressionStrategy compressionStrategy = this.indexSpec.getDimensionCompression();
        BitmapSerdeFactory bitmapSerdeFactory = this.indexSpec.getBitmapSerdeFactory();
        ColumnDescriptor.Builder builder = ColumnDescriptor.builder();
        builder.setValueType(ValueType.STRING);
        builder.setHasMultipleValues(hasMultiValue);
        DictionaryEncodedColumnPartSerde.SerializerBuilder partBuilder = DictionaryEncodedColumnPartSerde.serializerBuilder().withDictionary(this.dictionaryWriter).withValue(this.encodedValueWriter, hasMultiValue, compressionStrategy != CompressionStrategy.UNCOMPRESSED).withBitmapSerdeFactory(bitmapSerdeFactory).withBitmapIndex(this.bitmapWriter).withSpatialIndex(this.spatialWriter).withByteOrder(IndexIO.BYTE_ORDER);
        ColumnDescriptor serdeficator = builder.addSerde(partBuilder.build()).build();
        return serdeficator;
    }

    protected IndexSeeker[] toIndexSeekers(List<IndexableAdapter> adapters, ArrayList<IntBuffer> dimConversions, String dimension) {
        IndexSeeker[] seekers = new IndexSeeker[adapters.size()];
        for (int i = 0; i < adapters.size(); ++i) {
            Indexed<Comparable> dimValueLookup;
            IntBuffer dimConversion = dimConversions.get(i);
            seekers[i] = dimConversion != null ? new IndexSeekerWithConversion((IntBuffer)dimConversion.asReadOnlyBuffer().rewind()) : new IndexSeekerWithoutConversion((dimValueLookup = adapters.get(i).getDimValueLookup(dimension)) == null ? 0 : dimValueLookup.size());
        }
        return seekers;
    }

    protected boolean isNullColumn(Iterable<String> dimValues) {
        if (dimValues == null) {
            return true;
        }
        for (String val : dimValues) {
            if (val == null) continue;
            return false;
        }
        return true;
    }

    public static class ConvertingBitmapValues
    implements IntIterable {
        private final BitmapValues baseValues;
        private final IntBuffer conversionBuffer;

        ConvertingBitmapValues(BitmapValues baseValues, IntBuffer conversionBuffer) {
            this.baseValues = baseValues;
            this.conversionBuffer = conversionBuffer;
        }

        @Override
        @Nonnull
        public IntIterator iterator() {
            final IntIterator baseIterator = this.baseValues.iterator();
            return new IntIterator(){

                @Override
                public boolean hasNext() {
                    return baseIterator.hasNext();
                }

                @Override
                public int nextInt() {
                    return conversionBuffer.get(baseIterator.nextInt());
                }

                @Override
                public int skip(int n) {
                    return IntIteratorUtils.skip(baseIterator, n);
                }
            };
        }
    }

    protected static class IndexSeekerWithConversion
    implements IndexSeeker {
        private final IntBuffer dimConversions;
        private int currIndex;
        private int currVal;
        private int lastVal;

        IndexSeekerWithConversion(IntBuffer dimConversions) {
            this.dimConversions = dimConversions;
            this.currIndex = 0;
            this.currVal = -1;
            this.lastVal = -1;
        }

        @Override
        public int seek(int dictId) {
            if (this.dimConversions == null) {
                return -1;
            }
            if (this.lastVal != -1) {
                if (dictId <= this.lastVal) {
                    throw new ISE("Value dictId[%d] is less than the last value dictId[%d] I have, cannot be.", dictId, this.lastVal);
                }
                return -1;
            }
            if (this.currVal == -1) {
                this.currVal = this.dimConversions.get();
            }
            if (this.currVal == dictId) {
                int ret = this.currIndex++;
                if (this.dimConversions.hasRemaining()) {
                    this.currVal = this.dimConversions.get();
                } else {
                    this.lastVal = dictId;
                }
                return ret;
            }
            if (this.currVal < dictId) {
                throw new ISE("Skipped currValue dictId[%d], currIndex[%d]; incoming value dictId[%d]", this.currVal, this.currIndex, dictId);
            }
            return -1;
        }
    }

    protected static class IndexSeekerWithoutConversion
    implements IndexSeeker {
        private final int limit;

        public IndexSeekerWithoutConversion(int limit) {
            this.limit = limit;
        }

        @Override
        public int seek(int dictId) {
            return dictId < this.limit ? dictId : -1;
        }
    }

    protected static interface IndexSeeker {
        public static final int NOT_EXIST = -1;
        public static final int NOT_INIT = -1;

        public int seek(int var1);
    }
}

