/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import java.io.IOException;
import java.nio.IntBuffer;
import java.util.List;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.io.druid.segment.DimensionMergerV9;
import org.apache.hive.druid.io.druid.segment.IndexIO;
import org.apache.hive.druid.io.druid.segment.IndexSpec;
import org.apache.hive.druid.io.druid.segment.IndexableAdapter;
import org.apache.hive.druid.io.druid.segment.LongColumnSerializer;
import org.apache.hive.druid.io.druid.segment.column.ColumnDescriptor;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.data.CompressionFactory;
import org.apache.hive.druid.io.druid.segment.data.CompressionStrategy;
import org.apache.hive.druid.io.druid.segment.serde.LongGenericColumnPartSerde;
import org.apache.hive.druid.io.druid.segment.writeout.SegmentWriteOutMedium;

public class LongDimensionMergerV9
implements DimensionMergerV9<Long> {
    protected String dimensionName;
    protected final IndexSpec indexSpec;
    protected LongColumnSerializer serializer;

    LongDimensionMergerV9(String dimensionName, IndexSpec indexSpec, SegmentWriteOutMedium segmentWriteOutMedium) {
        this.dimensionName = dimensionName;
        this.indexSpec = indexSpec;
        try {
            this.setupEncodedValueWriter(segmentWriteOutMedium);
        }
        catch (IOException ioe) {
            Throwables.propagate(ioe);
        }
    }

    protected void setupEncodedValueWriter(SegmentWriteOutMedium segmentWriteOutMedium) throws IOException {
        CompressionStrategy metCompression = this.indexSpec.getMetricCompression();
        CompressionFactory.LongEncodingStrategy longEncoding = this.indexSpec.getLongEncoding();
        this.serializer = LongColumnSerializer.create(segmentWriteOutMedium, this.dimensionName, metCompression, longEncoding);
        this.serializer.open();
    }

    @Override
    public void writeMergedValueMetadata(List<IndexableAdapter> adapters) throws IOException {
    }

    @Override
    public Long convertSegmentRowValuesToMergedRowValues(Long segmentRow, int segmentIndexNumber) {
        return segmentRow;
    }

    @Override
    public void processMergedRow(Long rowValues) throws IOException {
        this.serializer.serialize(rowValues);
    }

    @Override
    public void writeIndexes(List<IntBuffer> segmentRowNumConversions) throws IOException {
    }

    @Override
    public boolean canSkip() {
        return false;
    }

    @Override
    public ColumnDescriptor makeColumnDescriptor() throws IOException {
        ColumnDescriptor.Builder builder = ColumnDescriptor.builder();
        builder.setValueType(ValueType.LONG);
        builder.addSerde(LongGenericColumnPartSerde.serializerBuilder().withByteOrder(IndexIO.BYTE_ORDER).withDelegate(this.serializer).build());
        return builder.build();
    }
}

