/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.topn;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.topn.DimValHolder;
import org.apache.hive.druid.io.druid.query.topn.DimensionAndMetricValueExtractor;
import org.apache.hive.druid.io.druid.query.topn.TopNQueryQueryToolChest;
import org.apache.hive.druid.io.druid.query.topn.TopNResultBuilder;
import org.apache.hive.druid.io.druid.query.topn.TopNResultValue;
import org.joda.time.DateTime;

public class TopNLexicographicResultBuilder
implements TopNResultBuilder {
    private static final int LOOP_UNROLL_COUNT = 8;
    private final DateTime timestamp;
    private final DimensionSpec dimSpec;
    private final String previousStop;
    private final Comparator comparator;
    private final String[] aggFactoryNames;
    private final PriorityQueue<DimValHolder> pQueue;
    private final int threshold;

    public TopNLexicographicResultBuilder(DateTime timestamp, DimensionSpec dimSpec, int threshold, String previousStop, final Comparator comparator, List<AggregatorFactory> aggFactories) {
        this.timestamp = timestamp;
        this.dimSpec = dimSpec;
        this.previousStop = previousStop;
        this.comparator = comparator;
        this.aggFactoryNames = TopNQueryQueryToolChest.extractFactoryName(aggFactories);
        this.threshold = threshold;
        this.pQueue = new PriorityQueue<DimValHolder>(threshold + 1, new Comparator<DimValHolder>(){

            @Override
            public int compare(DimValHolder o1, DimValHolder o2) {
                return comparator.compare(o2.getDimName(), o1.getDimName());
            }
        });
    }

    @Override
    public TopNResultBuilder addEntry(Comparable dimNameObj, Object dimValIndex, Object[] metricVals) {
        String dimName = Objects.toString(dimNameObj, null);
        HashMap<String, Object> metricValues = Maps.newHashMapWithExpectedSize(metricVals.length + 1);
        if (this.shouldAdd(dimName)) {
            metricValues.put(this.dimSpec.getOutputName(), dimName);
            int extra = metricVals.length % 8;
            switch (extra) {
                case 7: {
                    metricValues.put(this.aggFactoryNames[6], metricVals[6]);
                }
                case 6: {
                    metricValues.put(this.aggFactoryNames[5], metricVals[5]);
                }
                case 5: {
                    metricValues.put(this.aggFactoryNames[4], metricVals[4]);
                }
                case 4: {
                    metricValues.put(this.aggFactoryNames[3], metricVals[3]);
                }
                case 3: {
                    metricValues.put(this.aggFactoryNames[2], metricVals[2]);
                }
                case 2: {
                    metricValues.put(this.aggFactoryNames[1], metricVals[1]);
                }
                case 1: {
                    metricValues.put(this.aggFactoryNames[0], metricVals[0]);
                }
            }
            for (int i = extra; i < metricVals.length; i += 8) {
                metricValues.put(this.aggFactoryNames[i + 0], metricVals[i + 0]);
                metricValues.put(this.aggFactoryNames[i + 1], metricVals[i + 1]);
                metricValues.put(this.aggFactoryNames[i + 2], metricVals[i + 2]);
                metricValues.put(this.aggFactoryNames[i + 3], metricVals[i + 3]);
                metricValues.put(this.aggFactoryNames[i + 4], metricVals[i + 4]);
                metricValues.put(this.aggFactoryNames[i + 5], metricVals[i + 5]);
                metricValues.put(this.aggFactoryNames[i + 6], metricVals[i + 6]);
                metricValues.put(this.aggFactoryNames[i + 7], metricVals[i + 7]);
            }
            this.pQueue.add(new DimValHolder.Builder().withDimName((Comparable)((Object)dimName)).withMetricValues(metricValues).build());
            if (this.pQueue.size() > this.threshold) {
                this.pQueue.poll();
            }
        }
        return this;
    }

    @Override
    public TopNResultBuilder addEntry(DimensionAndMetricValueExtractor dimensionAndMetricValueExtractor) {
        Object dimensionValueObj = dimensionAndMetricValueExtractor.getDimensionValue(this.dimSpec.getOutputName());
        String dimensionValue = Objects.toString(dimensionValueObj, null);
        if (this.shouldAdd(dimensionValue)) {
            this.pQueue.add(new DimValHolder.Builder().withDimName((Comparable)((Object)dimensionValue)).withMetricValues(dimensionAndMetricValueExtractor.getBaseObject()).build());
            if (this.pQueue.size() > this.threshold) {
                this.pQueue.poll();
            }
        }
        return this;
    }

    @Override
    public Iterator<DimValHolder> getTopNIterator() {
        return this.pQueue.iterator();
    }

    @Override
    public Result<TopNResultValue> build() {
        DimValHolder[] holderValueArray = this.pQueue.toArray(new DimValHolder[0]);
        Arrays.sort(holderValueArray, new Comparator<DimValHolder>(){

            @Override
            public int compare(DimValHolder o1, DimValHolder o2) {
                return TopNLexicographicResultBuilder.this.comparator.compare(o1.getDimName(), o2.getDimName());
            }
        });
        return new Result<TopNResultValue>(this.timestamp, new TopNResultValue(Lists.transform(Arrays.asList(holderValueArray), new Function<DimValHolder, Object>(){

            @Override
            public Object apply(DimValHolder dimValHolder) {
                return dimValHolder.getMetricValues();
            }
        })));
    }

    private boolean shouldAdd(String dimName) {
        boolean belowThreshold = this.pQueue.size() < this.threshold;
        boolean belowMax = belowThreshold || this.comparator.compare(this.pQueue.peek().getTopNMetricVal(), dimName) < 0;
        return belowMax && (this.previousStop == null || this.comparator.compare(dimName, this.previousStop) > 0);
    }
}

