/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.metadata;

import com.google.inject.Inject;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Functions;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.io.druid.common.guava.CombiningSequence;
import org.apache.hive.druid.io.druid.data.input.impl.TimestampSpec;
import org.apache.hive.druid.io.druid.java.util.common.JodaUtils;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularity;
import org.apache.hive.druid.io.druid.java.util.common.guava.Comparators;
import org.apache.hive.druid.io.druid.java.util.common.guava.MappedSequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.nary.BinaryFn;
import org.apache.hive.druid.io.druid.query.BySegmentSkippingQueryRunner;
import org.apache.hive.druid.io.druid.query.CacheStrategy;
import org.apache.hive.druid.io.druid.query.DefaultGenericQueryMetricsFactory;
import org.apache.hive.druid.io.druid.query.GenericQueryMetricsFactory;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryMetrics;
import org.apache.hive.druid.io.druid.query.QueryPlus;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryToolChest;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactoryNotMergeableException;
import org.apache.hive.druid.io.druid.query.aggregation.MetricManipulationFn;
import org.apache.hive.druid.io.druid.query.metadata.SegmentMetadataQueryConfig;
import org.apache.hive.druid.io.druid.query.metadata.metadata.ColumnAnalysis;
import org.apache.hive.druid.io.druid.query.metadata.metadata.SegmentAnalysis;
import org.apache.hive.druid.io.druid.query.metadata.metadata.SegmentMetadataQuery;
import org.apache.hive.druid.io.druid.timeline.LogicalSegment;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePeriod;

public class SegmentMetadataQueryQueryToolChest
extends QueryToolChest<SegmentAnalysis, SegmentMetadataQuery> {
    private static final TypeReference<SegmentAnalysis> TYPE_REFERENCE = new TypeReference<SegmentAnalysis>(){};
    private static final byte[] SEGMENT_METADATA_CACHE_PREFIX = new byte[]{4};
    private static final Function<SegmentAnalysis, SegmentAnalysis> MERGE_TRANSFORM_FN = new Function<SegmentAnalysis, SegmentAnalysis>(){

        @Override
        public SegmentAnalysis apply(SegmentAnalysis analysis) {
            return SegmentMetadataQueryQueryToolChest.finalizeAnalysis(analysis);
        }
    };
    private final SegmentMetadataQueryConfig config;
    private final GenericQueryMetricsFactory queryMetricsFactory;

    @VisibleForTesting
    public SegmentMetadataQueryQueryToolChest(SegmentMetadataQueryConfig config) {
        this(config, DefaultGenericQueryMetricsFactory.instance());
    }

    @Inject
    public SegmentMetadataQueryQueryToolChest(SegmentMetadataQueryConfig config, GenericQueryMetricsFactory queryMetricsFactory) {
        this.config = config;
        this.queryMetricsFactory = queryMetricsFactory;
    }

    @Override
    public QueryRunner<SegmentAnalysis> mergeResults(QueryRunner<SegmentAnalysis> runner) {
        return new BySegmentSkippingQueryRunner<SegmentAnalysis>(runner){

            @Override
            public Sequence<SegmentAnalysis> doRun(QueryRunner<SegmentAnalysis> baseRunner, QueryPlus<SegmentAnalysis> queryPlus, Map<String, Object> context) {
                SegmentMetadataQuery updatedQuery = ((SegmentMetadataQuery)queryPlus.getQuery()).withFinalizedAnalysisTypes(SegmentMetadataQueryQueryToolChest.this.config);
                QueryPlus<SegmentAnalysis> updatedQueryPlus = queryPlus.withQuery(updatedQuery);
                return new MappedSequence<SegmentAnalysis, SegmentAnalysis>(CombiningSequence.create(baseRunner.run(updatedQueryPlus, context), this.makeOrdering(updatedQuery), this.createMergeFn(updatedQuery)), MERGE_TRANSFORM_FN::apply);
            }

            private Ordering<SegmentAnalysis> makeOrdering(SegmentMetadataQuery query) {
                if (query.isMerge()) {
                    return Comparators.alwaysEqual();
                }
                return query.getResultOrdering();
            }

            private BinaryFn<SegmentAnalysis, SegmentAnalysis, SegmentAnalysis> createMergeFn(final SegmentMetadataQuery inQ) {
                return new BinaryFn<SegmentAnalysis, SegmentAnalysis, SegmentAnalysis>(){

                    @Override
                    public SegmentAnalysis apply(SegmentAnalysis arg1, SegmentAnalysis arg2) {
                        return SegmentMetadataQueryQueryToolChest.mergeAnalyses(arg1, arg2, inQ.isLenientAggregatorMerge());
                    }
                };
            }
        };
    }

    @Override
    public QueryMetrics<Query<?>> makeMetrics(SegmentMetadataQuery query) {
        return this.queryMetricsFactory.makeMetrics(query);
    }

    @Override
    public Function<SegmentAnalysis, SegmentAnalysis> makePreComputeManipulatorFn(SegmentMetadataQuery query, MetricManipulationFn fn) {
        return Functions.identity();
    }

    @Override
    public TypeReference<SegmentAnalysis> getResultTypeReference() {
        return TYPE_REFERENCE;
    }

    @Override
    public CacheStrategy<SegmentAnalysis, SegmentAnalysis, SegmentMetadataQuery> getCacheStrategy(SegmentMetadataQuery query) {
        return new CacheStrategy<SegmentAnalysis, SegmentAnalysis, SegmentMetadataQuery>(){

            @Override
            public boolean isCacheable(SegmentMetadataQuery query, boolean willMergeRunners) {
                return true;
            }

            @Override
            public byte[] computeCacheKey(SegmentMetadataQuery query) {
                SegmentMetadataQuery updatedQuery = query.withFinalizedAnalysisTypes(SegmentMetadataQueryQueryToolChest.this.config);
                byte[] includerBytes = updatedQuery.getToInclude().getCacheKey();
                byte[] analysisTypesBytes = updatedQuery.getAnalysisTypesCacheKey();
                return ByteBuffer.allocate(1 + includerBytes.length + analysisTypesBytes.length).put(SEGMENT_METADATA_CACHE_PREFIX).put(includerBytes).put(analysisTypesBytes).array();
            }

            @Override
            public TypeReference<SegmentAnalysis> getCacheObjectClazz() {
                return SegmentMetadataQueryQueryToolChest.this.getResultTypeReference();
            }

            @Override
            public Function<SegmentAnalysis, SegmentAnalysis> prepareForCache() {
                return new Function<SegmentAnalysis, SegmentAnalysis>(){

                    @Override
                    public SegmentAnalysis apply(@Nullable SegmentAnalysis input) {
                        return input;
                    }
                };
            }

            @Override
            public Function<SegmentAnalysis, SegmentAnalysis> pullFromCache() {
                return new Function<SegmentAnalysis, SegmentAnalysis>(){

                    @Override
                    public SegmentAnalysis apply(@Nullable SegmentAnalysis input) {
                        return input;
                    }
                };
            }
        };
    }

    @Override
    public <T extends LogicalSegment> List<T> filterSegments(SegmentMetadataQuery query, List<T> segments) {
        if (!query.isUsingDefaultInterval()) {
            return segments;
        }
        if (segments.size() <= 1) {
            return segments;
        }
        LogicalSegment max = (LogicalSegment)segments.get(segments.size() - 1);
        DateTime targetEnd = max.getInterval().getEnd();
        final Interval targetInterval = new Interval((ReadablePeriod)this.config.getDefaultHistory(), (ReadableInstant)targetEnd);
        return Lists.newArrayList(Iterables.filter(segments, new Predicate<T>(){

            @Override
            public boolean apply(T input) {
                return input.getInterval().overlaps((ReadableInterval)targetInterval);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public static SegmentAnalysis mergeAnalyses(SegmentAnalysis arg1, SegmentAnalysis arg2, boolean lenientAggregatorMerge) {
        void var12_23;
        if (arg1 == null) {
            return arg2;
        }
        if (arg2 == null) {
            return arg1;
        }
        ArrayList<Interval> newIntervals = null;
        if (arg1.getIntervals() != null) {
            newIntervals = Lists.newArrayList();
            newIntervals.addAll(arg1.getIntervals());
        }
        if (arg2.getIntervals() != null) {
            if (newIntervals == null) {
                newIntervals = Lists.newArrayList();
            }
            newIntervals.addAll(arg2.getIntervals());
        }
        Map<String, ColumnAnalysis> leftColumns = arg1.getColumns();
        Map<String, ColumnAnalysis> rightColumns = arg2.getColumns();
        TreeMap<String, ColumnAnalysis> columns = Maps.newTreeMap();
        HashSet<String> rightColumnNames = Sets.newHashSet(rightColumns.keySet());
        for (Map.Entry<String, ColumnAnalysis> entry : leftColumns.entrySet()) {
            String columnName = entry.getKey();
            columns.put(columnName, entry.getValue().fold(rightColumns.get(columnName)));
            rightColumnNames.remove(columnName);
        }
        for (String string : rightColumnNames) {
            columns.put(string, rightColumns.get(string));
        }
        HashMap<String, AggregatorFactory> aggregators = Maps.newHashMap();
        if (lenientAggregatorMerge) {
            for (SegmentAnalysis analysis : ImmutableList.of(arg1, arg2)) {
                if (analysis.getAggregators() == null) continue;
                for (Map.Entry<String, AggregatorFactory> entry : analysis.getAggregators().entrySet()) {
                    String aggregatorName = entry.getKey();
                    AggregatorFactory aggregator = entry.getValue();
                    AggregatorFactory merged = (AggregatorFactory)aggregators.get(aggregatorName);
                    if (merged != null) {
                        try {
                            merged = merged.getMergingFactory(aggregator);
                        }
                        catch (AggregatorFactoryNotMergeableException e) {
                            merged = null;
                        }
                    } else {
                        merged = aggregator;
                    }
                    aggregators.put(aggregatorName, merged);
                }
            }
        } else {
            AggregatorFactory[] aggs2;
            AggregatorFactory[] aggregatorFactoryArray = arg1.getAggregators() != null ? arg1.getAggregators().values().toArray(new AggregatorFactory[arg1.getAggregators().size()]) : null;
            AggregatorFactory[] merged = AggregatorFactory.mergeAggregators(Arrays.asList(aggregatorFactoryArray, aggs2 = arg2.getAggregators() != null ? arg2.getAggregators().values().toArray(new AggregatorFactory[arg2.getAggregators().size()]) : null));
            if (merged != null) {
                for (AggregatorFactory aggregator : merged) {
                    aggregators.put(aggregator.getName(), aggregator);
                }
            }
        }
        TimestampSpec timestampSpec = TimestampSpec.mergeTimestampSpec(Lists.newArrayList(arg1.getTimestampSpec(), arg2.getTimestampSpec()));
        Granularity queryGranularity = Granularity.mergeGranularities(Lists.newArrayList(arg1.getQueryGranularity(), arg2.getQueryGranularity()));
        String mergedId = arg1.getId() != null && arg2.getId() != null && arg1.getId().equals(arg2.getId()) ? arg1.getId() : "merged";
        if (arg1.isRollup() != null && arg2.isRollup() != null && arg1.isRollup().equals(arg2.isRollup())) {
            Boolean bl = arg1.isRollup();
        } else {
            Object var12_22 = null;
        }
        return new SegmentAnalysis(mergedId, newIntervals, columns, arg1.getSize() + arg2.getSize(), arg1.getNumRows() + arg2.getNumRows(), aggregators.isEmpty() ? null : aggregators, timestampSpec, queryGranularity, (Boolean)var12_23);
    }

    @VisibleForTesting
    public static SegmentAnalysis finalizeAnalysis(SegmentAnalysis analysis) {
        return new SegmentAnalysis(analysis.getId(), analysis.getIntervals() != null ? JodaUtils.condenseIntervals(analysis.getIntervals()) : null, analysis.getColumns(), analysis.getSize(), analysis.getNumRows(), analysis.getAggregators(), analysis.getTimestampSpec(), analysis.getQueryGranularity(), analysis.isRollup());
    }

    public SegmentMetadataQueryConfig getConfig() {
        return this.config;
    }
}

