/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.groupby.having;

import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.io.druid.data.input.Row;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.groupby.having.BaseHavingSpec;
import org.apache.hive.druid.io.druid.query.groupby.having.HavingSpecMetricComparator;

public class GreaterThanHavingSpec
extends BaseHavingSpec {
    private final String aggregationName;
    private final Number value;
    private volatile Map<String, AggregatorFactory> aggregators;

    @JsonCreator
    public GreaterThanHavingSpec(@JsonProperty(value="aggregation") String aggName, @JsonProperty(value="value") Number value) {
        this.aggregationName = aggName;
        this.value = value;
    }

    @JsonProperty(value="aggregation")
    public String getAggregationName() {
        return this.aggregationName;
    }

    @JsonProperty(value="value")
    public Number getValue() {
        return this.value;
    }

    @Override
    public void setAggregators(Map<String, AggregatorFactory> aggregators) {
        this.aggregators = aggregators;
    }

    @Override
    public boolean eval(Row row) {
        return HavingSpecMetricComparator.compare(row, this.aggregationName, this.value, this.aggregators) > 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GreaterThanHavingSpec that = (GreaterThanHavingSpec)o;
        if (this.value != null && that.value != null) {
            return Double.compare(this.value.doubleValue(), that.value.doubleValue()) == 0;
        }
        return this.value == null && that.value == null;
    }

    public int hashCode() {
        int result = this.aggregationName != null ? this.aggregationName.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GreaterThanHavingSpec");
        sb.append("{aggregationName='").append(this.aggregationName).append('\'');
        sb.append(", value=").append(this.value);
        sb.append('}');
        return sb.toString();
    }
}

