/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.groupby.epinephelinae;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.java.util.common.parsers.CloseableIterator;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.BufferAggregator;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.AggregateResult;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.Grouper;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.IntGrouper;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;

public class BufferArrayGrouper
implements IntGrouper {
    private static final Logger LOG = new Logger(BufferArrayGrouper.class);
    private final Supplier<ByteBuffer> bufferSupplier;
    private final BufferAggregator[] aggregators;
    private final int[] aggregatorOffsets;
    private final int cardinalityWithMissingValue;
    private final int recordSize;
    private boolean initialized = false;
    private ByteBuffer usedFlagBuffer;
    private ByteBuffer valBuffer;

    static int requiredBufferCapacity(int cardinality, AggregatorFactory[] aggregatorFactories) {
        int cardinalityWithMissingValue = cardinality + 1;
        int recordSize = Arrays.stream(aggregatorFactories).mapToInt(AggregatorFactory::getMaxIntermediateSize).sum();
        return BufferArrayGrouper.getUsedFlagBufferCapacity(cardinalityWithMissingValue) + cardinalityWithMissingValue * recordSize;
    }

    private static int getUsedFlagBufferCapacity(int cardinalityWithMissingValue) {
        return (cardinalityWithMissingValue + 8 - 1) / 8;
    }

    public BufferArrayGrouper(Supplier<ByteBuffer> bufferSupplier, ColumnSelectorFactory columnSelectorFactory, AggregatorFactory[] aggregatorFactories, int cardinality) {
        Preconditions.checkNotNull(aggregatorFactories, "aggregatorFactories");
        Preconditions.checkArgument(cardinality > 0, "Cardinality must a non-zero positive number");
        this.bufferSupplier = Preconditions.checkNotNull(bufferSupplier, "bufferSupplier");
        this.aggregators = new BufferAggregator[aggregatorFactories.length];
        this.aggregatorOffsets = new int[aggregatorFactories.length];
        this.cardinalityWithMissingValue = cardinality + 1;
        int offset = 0;
        for (int i = 0; i < aggregatorFactories.length; ++i) {
            this.aggregators[i] = aggregatorFactories[i].factorizeBuffered(columnSelectorFactory);
            this.aggregatorOffsets[i] = offset;
            offset += aggregatorFactories[i].getMaxIntermediateSize();
        }
        this.recordSize = offset;
    }

    @Override
    public void init() {
        if (!this.initialized) {
            ByteBuffer buffer = this.bufferSupplier.get();
            int usedFlagBufferEnd = BufferArrayGrouper.getUsedFlagBufferCapacity(this.cardinalityWithMissingValue);
            buffer.position(0);
            buffer.limit(usedFlagBufferEnd);
            this.usedFlagBuffer = buffer.slice();
            buffer.position(usedFlagBufferEnd);
            buffer.limit(buffer.capacity());
            this.valBuffer = buffer.slice();
            this.reset();
            this.initialized = true;
        }
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public AggregateResult aggregateKeyHash(int dimIndex) {
        Preconditions.checkArgument(dimIndex >= 0 && dimIndex < this.cardinalityWithMissingValue, "Invalid dimIndex[%s]", new Object[]{dimIndex});
        int recordOffset = dimIndex * this.recordSize;
        if (recordOffset + this.recordSize > this.valBuffer.capacity()) {
            throw new ISE("A record of size [%d] cannot be written to the array buffer at offset[%d] because it exceeds the buffer capacity[%d]. Try increasing druid.processing.buffer.sizeBytes", this.recordSize, recordOffset, this.valBuffer.capacity());
        }
        if (!this.isUsedSlot(dimIndex)) {
            this.initializeSlot(dimIndex);
        }
        for (int i = 0; i < this.aggregators.length; ++i) {
            this.aggregators[i].aggregate(this.valBuffer, recordOffset + this.aggregatorOffsets[i]);
        }
        return AggregateResult.ok();
    }

    private void initializeSlot(int dimIndex) {
        int index = dimIndex / 8;
        int extraIndex = dimIndex % 8;
        this.usedFlagBuffer.put(index, (byte)(this.usedFlagBuffer.get(index) | 1 << extraIndex));
        int recordOffset = dimIndex * this.recordSize;
        for (int i = 0; i < this.aggregators.length; ++i) {
            this.aggregators[i].init(this.valBuffer, recordOffset + this.aggregatorOffsets[i]);
        }
    }

    private boolean isUsedSlot(int dimIndex) {
        int index = dimIndex / 8;
        int extraIndex = dimIndex % 8;
        int usedFlagByte = 1 << extraIndex;
        return (this.usedFlagBuffer.get(index) & usedFlagByte) != 0;
    }

    @Override
    public void reset() {
        int i;
        int usedFlagBufferCapacity = this.usedFlagBuffer.capacity();
        int n = usedFlagBufferCapacity / 8 * 8;
        for (i = 0; i < n; i += 8) {
            this.usedFlagBuffer.putLong(i, 0L);
        }
        for (i = n; i < usedFlagBufferCapacity; ++i) {
            this.usedFlagBuffer.put(i, (byte)0);
        }
    }

    @Override
    public IntGrouper.IntGrouperHashFunction hashFunction() {
        return key -> key + 1;
    }

    @Override
    public void close() {
        for (BufferAggregator aggregator : this.aggregators) {
            try {
                aggregator.close();
            }
            catch (Exception e) {
                LOG.warn(e, "Could not close aggregator [%s], skipping.", aggregator);
            }
        }
    }

    @Override
    public CloseableIterator<Grouper.Entry<Integer>> iterator(boolean sorted) {
        if (sorted) {
            throw new UnsupportedOperationException("sorted iterator is not supported yet");
        }
        return new CloseableIterator<Grouper.Entry<Integer>>(){
            int cur = this.findNext();
            boolean findNext = false;

            @Override
            public boolean hasNext() {
                if (this.findNext) {
                    this.cur = this.findNext();
                    this.findNext = false;
                }
                return this.cur >= 0;
            }

            private int findNext() {
                for (int i = this.cur + 1; i < BufferArrayGrouper.this.cardinalityWithMissingValue; ++i) {
                    if (!BufferArrayGrouper.this.isUsedSlot(i)) continue;
                    return i;
                }
                return -1;
            }

            @Override
            public Grouper.Entry<Integer> next() {
                if (this.cur < 0) {
                    throw new NoSuchElementException();
                }
                this.findNext = true;
                Object[] values = new Object[BufferArrayGrouper.this.aggregators.length];
                int recordOffset = this.cur * BufferArrayGrouper.this.recordSize;
                for (int i = 0; i < BufferArrayGrouper.this.aggregators.length; ++i) {
                    values[i] = BufferArrayGrouper.this.aggregators[i].get(BufferArrayGrouper.this.valBuffer, recordOffset + BufferArrayGrouper.this.aggregatorOffsets[i]);
                }
                return new Grouper.Entry<Integer>(this.cur - 1, values);
            }

            @Override
            public void close() throws IOException {
            }
        };
    }
}

