/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation.hyperloglog;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.codec.binary.Base64;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.io.druid.hll.HyperLogLogCollector;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.guava.Comparators;
import org.apache.hive.druid.io.druid.query.aggregation.AggregateCombiner;
import org.apache.hive.druid.io.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactoryNotMergeableException;
import org.apache.hive.druid.io.druid.query.aggregation.BufferAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.NoopAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.NoopBufferAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.cardinality.HyperLogLogCollectorAggregateCombiner;
import org.apache.hive.druid.io.druid.query.aggregation.hyperloglog.HyperUniquesAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.hyperloglog.HyperUniquesBufferAggregator;
import org.apache.hive.druid.io.druid.query.cache.CacheKeyBuilder;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.io.druid.segment.ColumnValueSelector;
import org.apache.hive.druid.io.druid.segment.NilColumnValueSelector;

public class HyperUniquesAggregatorFactory
extends AggregatorFactory {
    private final String name;
    private final String fieldName;
    private final boolean isInputHyperUnique;
    private final boolean round;

    public static Object estimateCardinality(Object object, boolean round) {
        if (object == null) {
            return 0;
        }
        HyperLogLogCollector collector = (HyperLogLogCollector)object;
        if (round) {
            return collector.estimateCardinalityRound();
        }
        return collector.estimateCardinality();
    }

    @JsonCreator
    public HyperUniquesAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="isInputHyperUnique") boolean isInputHyperUnique, @JsonProperty(value="round") boolean round) {
        this.name = name;
        this.fieldName = fieldName;
        this.isInputHyperUnique = isInputHyperUnique;
        this.round = round;
    }

    public HyperUniquesAggregatorFactory(String name, String fieldName) {
        this(name, fieldName, false, false);
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        ColumnValueSelector selector = metricFactory.makeColumnValueSelector(this.fieldName);
        if (selector instanceof NilColumnValueSelector) {
            return NoopAggregator.instance();
        }
        Class classOfObject = selector.classOfObject();
        if (classOfObject.equals(Object.class) || HyperLogLogCollector.class.isAssignableFrom(classOfObject)) {
            return new HyperUniquesAggregator(selector);
        }
        throw new IAE("Incompatible type for metric[%s], expected a HyperUnique, got a %s", this.fieldName, classOfObject);
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        ColumnValueSelector selector = metricFactory.makeColumnValueSelector(this.fieldName);
        if (selector instanceof NilColumnValueSelector) {
            return NoopBufferAggregator.instance();
        }
        Class classOfObject = selector.classOfObject();
        if (classOfObject.equals(Object.class) || HyperLogLogCollector.class.isAssignableFrom(classOfObject)) {
            return new HyperUniquesBufferAggregator(selector);
        }
        throw new IAE("Incompatible type for metric[%s], expected a HyperUnique, got a %s", this.fieldName, classOfObject);
    }

    @Override
    public Comparator getComparator() {
        return Comparators.naturalNullsFirst();
    }

    @Override
    public Object combine(Object lhs, Object rhs) {
        if (rhs == null) {
            return lhs;
        }
        if (lhs == null) {
            return rhs;
        }
        return ((HyperLogLogCollector)lhs).fold((HyperLogLogCollector)rhs);
    }

    @Override
    public AggregateCombiner makeAggregateCombiner() {
        return new HyperLogLogCollectorAggregateCombiner();
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new HyperUniquesAggregatorFactory(this.name, this.name, false, this.round);
    }

    @Override
    public AggregatorFactory getMergingFactory(AggregatorFactory other) throws AggregatorFactoryNotMergeableException {
        if (other.getName().equals(this.getName()) && this.getClass() == other.getClass()) {
            return this.getCombiningFactory();
        }
        throw new AggregatorFactoryNotMergeableException(this, other);
    }

    @Override
    public List<AggregatorFactory> getRequiredColumns() {
        return Arrays.asList(new HyperUniquesAggregatorFactory(this.fieldName, this.fieldName, this.isInputHyperUnique, this.round));
    }

    @Override
    public Object deserialize(Object object) {
        ByteBuffer buffer;
        if (object instanceof byte[]) {
            buffer = ByteBuffer.wrap((byte[])object);
        } else if (object instanceof ByteBuffer) {
            buffer = ((ByteBuffer)object).duplicate();
        } else if (object instanceof String) {
            buffer = ByteBuffer.wrap(Base64.decodeBase64((byte[])StringUtils.toUtf8((String)object)));
        } else {
            return object;
        }
        return HyperLogLogCollector.makeCollector(buffer);
    }

    @Override
    public Object finalizeComputation(Object object) {
        return HyperUniquesAggregatorFactory.estimateCardinality(object, this.round);
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> requiredFields() {
        return Collections.singletonList(this.fieldName);
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @JsonProperty
    public boolean getIsInputHyperUnique() {
        return this.isInputHyperUnique;
    }

    @JsonProperty
    public boolean isRound() {
        return this.round;
    }

    @Override
    public byte[] getCacheKey() {
        return new CacheKeyBuilder(5).appendString(this.fieldName).appendBoolean(this.round).build();
    }

    @Override
    public String getTypeName() {
        if (this.isInputHyperUnique) {
            return "preComputedHyperUnique";
        }
        return "hyperUnique";
    }

    @Override
    public int getMaxIntermediateSize() {
        return HyperLogLogCollector.getLatestNumBytesForDenseStorage();
    }

    public String toString() {
        return "HyperUniquesAggregatorFactory{name='" + this.name + '\'' + ", fieldName='" + this.fieldName + '\'' + ", isInputHyperUnique=" + this.isInputHyperUnique + ", round=" + this.round + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HyperUniquesAggregatorFactory that = (HyperUniquesAggregatorFactory)o;
        return this.isInputHyperUnique == that.isInputHyperUnique && this.round == that.round && Objects.equals(this.name, that.name) && Objects.equals(this.fieldName, that.fieldName);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.fieldName, this.isInputHyperUnique, this.round);
    }
}

