/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.metrics;

import java.lang.management.ManagementFactory;
import java.util.regex.Pattern;
import org.apache.hive.druid.com.metamx.common.RE;
import org.apache.hive.druid.com.metamx.metrics.PidDiscoverer;

public class JvmPidDiscoverer
implements PidDiscoverer {
    private static final JvmPidDiscoverer INSTANCE = new JvmPidDiscoverer();

    public static JvmPidDiscoverer instance() {
        return INSTANCE;
    }

    private JvmPidDiscoverer() {
    }

    @Override
    public long getPid() {
        return Inner.PID;
    }

    private static class Inner {
        private static final long PID;

        private Inner() {
        }

        static {
            String jvmName = ManagementFactory.getRuntimeMXBean().getName();
            String[] nameSplits = jvmName.split(Pattern.quote("@"));
            if (nameSplits.length != 2) {
                throw new RE("Unable to determine pid from [%s]", jvmName);
            }
            try {
                PID = Long.parseLong(nameSplits[0]);
            }
            catch (NumberFormatException nfe) {
                throw new RE(nfe, "Unable to determine pid from [%s]", jvmName);
            }
        }
    }
}

