/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.metrics;

import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceEmitter;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceMetricEvent;
import org.apache.hive.druid.com.metamx.metrics.FeedDefiningMonitor;
import org.apache.hive.druid.com.metamx.metrics.MonitorUtils;
import org.apache.hive.druid.com.metamx.metrics.cgroups.CgroupDiscoverer;
import org.apache.hive.druid.com.metamx.metrics.cgroups.CpuAcct;
import org.apache.hive.druid.com.metamx.metrics.cgroups.ProcSelfCgroupDiscoverer;
import org.joda.time.DateTime;

public class CpuAcctDeltaMonitor
extends FeedDefiningMonitor {
    private static final Logger log = new Logger(CpuAcctDeltaMonitor.class);
    private final AtomicReference<SnapshotHolder> priorSnapshot = new AtomicReference<Object>(null);
    private final Map<String, String[]> dimensions;
    private final CgroupDiscoverer cgroupDiscoverer;

    public CpuAcctDeltaMonitor() {
        this(ImmutableMap.of());
    }

    public CpuAcctDeltaMonitor(Map<String, String[]> dimensions) {
        this(dimensions, "metrics");
    }

    public CpuAcctDeltaMonitor(Map<String, String[]> dimensions, String feed) {
        this(feed, dimensions, new ProcSelfCgroupDiscoverer());
    }

    public CpuAcctDeltaMonitor(String feed, Map<String, String[]> dimensions, CgroupDiscoverer cgroupDiscoverer) {
        super(feed);
        Preconditions.checkNotNull(dimensions);
        this.dimensions = ImmutableMap.copyOf(dimensions);
        this.cgroupDiscoverer = Preconditions.checkNotNull(cgroupDiscoverer, "cgroupDiscoverer required");
    }

    @Override
    public boolean doMonitor(ServiceEmitter emitter) {
        CpuAcct cpuAcct = new CpuAcct(this.cgroupDiscoverer);
        CpuAcct.CpuAcctMetric snapshot = cpuAcct.snapshot();
        long nanoTime = System.nanoTime();
        DateTime dateTime = new DateTime();
        SnapshotHolder priorSnapshotHolder = this.priorSnapshot.get();
        if (!this.priorSnapshot.compareAndSet(priorSnapshotHolder, new SnapshotHolder(snapshot, nanoTime))) {
            log.debug("Pre-empted by another monitor run", new Object[0]);
            return false;
        }
        if (priorSnapshotHolder == null) {
            log.info("Detected first run, storing result for next run", new Object[0]);
            return false;
        }
        long elapsedNs = nanoTime - priorSnapshotHolder.timestamp;
        if (snapshot.cpuCount() != priorSnapshotHolder.metric.cpuCount()) {
            log.warn("Prior CPU count [%d] does not match current cpu count [%d]. Skipping metrics emission", priorSnapshotHolder.metric.cpuCount(), snapshot.cpuCount());
            return false;
        }
        for (int i = 0; i < snapshot.cpuCount(); ++i) {
            ServiceMetricEvent.Builder builderUsr = this.builder().setDimension("cpuName", Integer.toString(i)).setDimension("cpuTime", "usr");
            ServiceMetricEvent.Builder builderSys = this.builder().setDimension("cpuName", Integer.toString(i)).setDimension("cpuTime", "sys");
            MonitorUtils.addDimensionsToBuilder(builderUsr, this.dimensions);
            MonitorUtils.addDimensionsToBuilder(builderSys, this.dimensions);
            emitter.emit(builderUsr.build(dateTime, "cgroup/cpu_time_delta_ns", snapshot.usrTime(i) - priorSnapshotHolder.metric.usrTime(i)));
            emitter.emit(builderSys.build(dateTime, "cgroup/cpu_time_delta_ns", snapshot.sysTime(i) - priorSnapshotHolder.metric.sysTime(i)));
        }
        if (snapshot.cpuCount() > 0) {
            emitter.emit(this.builder().build(dateTime, "cgroup/cpu_time_delta_ns_elapsed", elapsedNs));
        }
        return true;
    }

    static class SnapshotHolder {
        private final CpuAcct.CpuAcctMetric metric;
        private final long timestamp;

        SnapshotHolder(CpuAcct.CpuAcctMetric metric, long timestamp) {
            this.metric = metric;
            this.timestamp = timestamp;
        }
    }
}

