/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.common.guava;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.metamx.common.guava.Accumulator;
import org.apache.hive.druid.com.metamx.common.guava.Sequence;
import org.apache.hive.druid.com.metamx.common.guava.Yielder;
import org.apache.hive.druid.com.metamx.common.guava.Yielders;
import org.apache.hive.druid.com.metamx.common.guava.YieldingAccumulator;
import org.apache.hive.druid.com.metamx.common.logger.Logger;

public class BaseSequence<T, IterType extends Iterator<T>>
implements Sequence<T> {
    private static final Logger log = new Logger(BaseSequence.class);
    private final IteratorMaker<T, IterType> maker;

    public static <T> Sequence<T> simple(final Iterable<T> iterable) {
        return new BaseSequence(new IteratorMaker<T, Iterator<T>>(){

            @Override
            public Iterator<T> make() {
                return iterable.iterator();
            }

            @Override
            public void cleanup(Iterator<T> iterFromMake) {
            }
        });
    }

    public BaseSequence(IteratorMaker<T, IterType> maker) {
        this.maker = maker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <OutType> OutType accumulate(OutType initValue, Accumulator<OutType, T> fn) {
        IterType iterator = this.maker.make();
        try {
            while (iterator.hasNext()) {
                initValue = fn.accumulate(initValue, iterator.next());
            }
            OutType OutType = initValue;
            return OutType;
        }
        finally {
            this.maker.cleanup(iterator);
        }
    }

    @Override
    public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, T> accumulator) {
        IterType iterator = this.maker.make();
        try {
            return this.makeYielder(initValue, accumulator, iterator);
        }
        catch (Exception e) {
            try {
                this.maker.cleanup(iterator);
            }
            catch (RuntimeException e1) {
                log.error(e1, "Exception thrown when closing maker.  Logging and ignoring.", new Object[0]);
            }
            throw Throwables.propagate(e);
        }
    }

    private <OutType> Yielder<OutType> makeYielder(OutType initValue, final YieldingAccumulator<OutType, T> accumulator, IterType iter) {
        OutType retVal = initValue;
        while (!accumulator.yielded() && iter.hasNext()) {
            retVal = accumulator.accumulate(retVal, iter.next());
        }
        if (!accumulator.yielded()) {
            return Yielders.done(retVal, new Closeable((Iterator)iter){
                final /* synthetic */ Iterator val$iter;
                {
                    this.val$iter = iterator;
                }

                @Override
                public void close() throws IOException {
                    BaseSequence.this.maker.cleanup(this.val$iter);
                }
            });
        }
        final OutType finalRetVal = retVal;
        return new Yielder<OutType>((Iterator)iter){
            final /* synthetic */ Iterator val$iter;
            {
                this.val$iter = iterator;
            }

            @Override
            public OutType get() {
                return finalRetVal;
            }

            @Override
            public Yielder<OutType> next(OutType initValue) {
                accumulator.reset();
                try {
                    return BaseSequence.this.makeYielder(initValue, accumulator, this.val$iter);
                }
                catch (Exception e) {
                    try {
                        BaseSequence.this.maker.cleanup(this.val$iter);
                    }
                    catch (RuntimeException e1) {
                        log.error(e1, "Exception thrown when closing maker.  Logging and ignoring.", new Object[0]);
                    }
                    throw Throwables.propagate(e);
                }
            }

            @Override
            public boolean isDone() {
                return false;
            }

            @Override
            public void close() throws IOException {
                BaseSequence.this.maker.cleanup(this.val$iter);
            }
        };
    }

    public static interface IteratorMaker<T, IterType extends Iterator<T>> {
        public IterType make();

        public void cleanup(IterType var1);
    }
}

